/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.events.transactionsEvents;

import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.Event;
import java.math.BigDecimal;

public class ExchangeEvent
extends Event {
    private final Player player;
    private final Currency fromCurrency;
    private final Currency toCurrency;
    private final BigDecimal amount;
    private final double exchangeRate;
    private final BigDecimal exchangedAmount;

    public ExchangeEvent(Player player, Currency fromCurrency, Currency toCurrency, BigDecimal amount, double exchangeRate, BigDecimal exchangedAmount) {
        this.player = new Player(player);
        this.fromCurrency = new Currency(fromCurrency);
        this.toCurrency = new Currency(toCurrency);
        this.amount = amount;
        this.exchangeRate = exchangeRate;
        this.exchangedAmount = exchangedAmount;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Currency getFromCurrency() {
        return this.fromCurrency;
    }

    public Currency getToCurrency() {
        return this.toCurrency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public double getExchangeRate() {
        return this.exchangeRate;
    }

    public BigDecimal getExchangedAmount() {
        return this.exchangedAmount;
    }

    public String toString() {
        return "ExchangeEvent{player=" + this.player.getNickname() + ", fromCurrency=" + this.fromCurrency.getSingular() + ", toCurrency=" + this.toCurrency.getSingular() + ", amount=" + this.amount.toString() + ", exchangeRate=" + this.exchangeRate + ", exchangedAmount=" + this.exchangedAmount.toString() + "}";
    }
}

