/*
 * Decompiled with CFR 0.152.
 */
package api;

public class EconomyResponse {
    private final ResponseType type;
    private final String errorMessage;

    private EconomyResponse(ResponseType type, String errorMessage) {
        this.type = type;
        this.errorMessage = errorMessage;
    }

    public static EconomyResponse success() {
        return new EconomyResponse(ResponseType.SUCCESS, null);
    }

    public static EconomyResponse failure(String errorMessage) {
        return new EconomyResponse(ResponseType.FAILURE, errorMessage);
    }

    public static EconomyResponse notImplemented() {
        return new EconomyResponse(ResponseType.NOT_IMPLEMENTED, "Method not implemented");
    }

    public boolean isSuccess() {
        return this.errorMessage == null;
    }

    public ResponseType getType() {
        return this.type;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum ResponseType {
        SUCCESS,
        FAILURE,
        NOT_IMPLEMENTED;

    }
}

