/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.mysql.cj.protocol.a.authentication;

import com.BlockDynasty.mysql.cj.Messages;
import com.BlockDynasty.mysql.cj.callback.MysqlCallbackHandler;
import com.BlockDynasty.mysql.cj.callback.UsernameCallback;
import com.BlockDynasty.mysql.cj.conf.PropertyKey;
import com.BlockDynasty.mysql.cj.conf.PropertySet;
import com.BlockDynasty.mysql.cj.conf.RuntimeProperty;
import com.BlockDynasty.mysql.cj.exceptions.CJException;
import com.BlockDynasty.mysql.cj.exceptions.ExceptionFactory;
import com.BlockDynasty.mysql.cj.exceptions.ExceptionInterceptor;
import com.BlockDynasty.mysql.cj.exceptions.UnableToConnectException;
import com.BlockDynasty.mysql.cj.exceptions.WrongArgumentException;
import com.BlockDynasty.mysql.cj.protocol.AuthenticationPlugin;
import com.BlockDynasty.mysql.cj.protocol.ExportControlled;
import com.BlockDynasty.mysql.cj.protocol.Protocol;
import com.BlockDynasty.mysql.cj.protocol.Security;
import com.BlockDynasty.mysql.cj.protocol.a.NativeConstants;
import com.BlockDynasty.mysql.cj.protocol.a.NativePacketPayload;
import com.BlockDynasty.mysql.cj.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

public class Sha256PasswordPlugin
implements AuthenticationPlugin<NativePacketPayload> {
    public static String PLUGIN_NAME = "sha256_password";
    protected Protocol<NativePacketPayload> protocol = null;
    protected MysqlCallbackHandler usernameCallbackHandler = null;
    protected String password = null;
    protected String seed = null;
    protected boolean publicKeyRequested = false;
    protected String publicKeyString = null;
    protected RuntimeProperty<String> serverRSAPublicKeyFile = null;

    @Override
    public void init(Protocol<NativePacketPayload> prot, MysqlCallbackHandler cbh) {
        this.protocol = prot;
        this.usernameCallbackHandler = cbh;
        this.serverRSAPublicKeyFile = this.protocol.getPropertySet().getStringProperty(PropertyKey.serverRSAPublicKeyFile);
        String pkURL = this.serverRSAPublicKeyFile.getValue();
        if (pkURL != null) {
            this.publicKeyString = Sha256PasswordPlugin.readRSAKey(pkURL, this.protocol.getPropertySet(), this.protocol.getExceptionInterceptor());
        }
    }

    @Override
    public void destroy() {
        this.reset();
        this.protocol = null;
        this.usernameCallbackHandler = null;
        this.password = null;
        this.seed = null;
        this.publicKeyRequested = false;
        this.publicKeyString = null;
        this.serverRSAPublicKeyFile = null;
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
        if (user == null && this.usernameCallbackHandler != null) {
            this.usernameCallbackHandler.handle(new UsernameCallback(System.getProperty("user.name")));
        }
    }

    @Override
    public boolean nextAuthenticationStep(NativePacketPayload fromServer, List<NativePacketPayload> toServer) {
        toServer.clear();
        if (this.password == null || this.password.length() == 0 || fromServer == null) {
            NativePacketPayload packet = new NativePacketPayload(new byte[]{0});
            toServer.add(packet);
        } else {
            try {
                if (this.protocol.getSocketConnection().isSSLEstablished()) {
                    NativePacketPayload packet = new NativePacketPayload(StringUtils.getBytes(this.password, this.protocol.getServerSession().getCharsetSettings().getPasswordCharacterEncoding()));
                    packet.setPosition(packet.getPayloadLength());
                    packet.writeInteger(NativeConstants.IntegerDataType.INT1, 0L);
                    packet.setPosition(0);
                    toServer.add(packet);
                } else if (this.serverRSAPublicKeyFile.getValue() != null) {
                    this.seed = fromServer.readString(NativeConstants.StringSelfDataType.STRING_TERM, null);
                    NativePacketPayload packet = new NativePacketPayload(this.encryptPassword());
                    toServer.add(packet);
                } else {
                    if (!this.protocol.getPropertySet().getBooleanProperty(PropertyKey.allowPublicKeyRetrieval).getValue().booleanValue()) {
                        throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("Sha256PasswordPlugin.2"), this.protocol.getExceptionInterceptor());
                    }
                    if (this.publicKeyRequested && fromServer.getPayloadLength() > 21) {
                        this.publicKeyString = fromServer.readString(NativeConstants.StringSelfDataType.STRING_TERM, null);
                        NativePacketPayload packet = new NativePacketPayload(this.encryptPassword());
                        toServer.add(packet);
                        this.publicKeyRequested = false;
                    } else {
                        this.seed = fromServer.readString(NativeConstants.StringSelfDataType.STRING_TERM, null);
                        NativePacketPayload packet = new NativePacketPayload(new byte[]{1});
                        toServer.add(packet);
                        this.publicKeyRequested = true;
                    }
                }
            }
            catch (CJException e) {
                throw ExceptionFactory.createException(e.getMessage(), e, this.protocol.getExceptionInterceptor());
            }
        }
        return true;
    }

    protected byte[] encryptPassword() {
        return this.encryptPassword("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
    }

    protected byte[] encryptPassword(String transformation) {
        byte[] byArray;
        byte[] input = null;
        if (this.password != null) {
            byArray = StringUtils.getBytesNullTerminated(this.password, this.protocol.getServerSession().getCharsetSettings().getPasswordCharacterEncoding());
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        }
        input = byArray;
        byte[] mysqlScrambleBuff = new byte[input.length];
        Security.xorString(input, mysqlScrambleBuff, this.seed.getBytes(), input.length);
        return ExportControlled.encryptWithRSAPublicKey(mysqlScrambleBuff, ExportControlled.decodeRSAPublicKey(this.publicKeyString), transformation);
    }

    protected static String readRSAKey(String pkPath, PropertySet propertySet, ExceptionInterceptor exceptionInterceptor) {
        String res = null;
        byte[] fileBuf = new byte[2048];
        BufferedInputStream fileIn = null;
        try {
            File f = new File(pkPath);
            String canonicalPath = f.getCanonicalPath();
            fileIn = new BufferedInputStream(new FileInputStream(canonicalPath));
            int bytesRead = 0;
            StringBuilder sb = new StringBuilder();
            while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                sb.append(StringUtils.toAsciiString(fileBuf, 0, bytesRead));
            }
            res = sb.toString();
        }
        catch (IOException ioEx) {
            Object[] objectArray;
            if (propertySet.getBooleanProperty(PropertyKey.paranoid).getValue().booleanValue()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = "";
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = "'" + pkPath + "'";
            }
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Sha256PasswordPlugin.0", objectArray), exceptionInterceptor);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    throw ExceptionFactory.createException(Messages.getString("Sha256PasswordPlugin.1"), e, exceptionInterceptor);
                }
            }
        }
        return res;
    }
}

