/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.redis.clients.jedis.mcf;

import com.BlockDynasty.redis.clients.jedis.CommandObject;
import com.BlockDynasty.redis.clients.jedis.Connection;
import com.BlockDynasty.redis.clients.jedis.annots.Experimental;
import com.BlockDynasty.redis.clients.jedis.executors.CommandExecutor;
import com.BlockDynasty.redis.clients.jedis.mcf.CircuitBreakerFailoverBase;
import com.BlockDynasty.redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;

@Experimental
public class CircuitBreakerCommandExecutor
extends CircuitBreakerFailoverBase
implements CommandExecutor {
    public CircuitBreakerCommandExecutor(MultiClusterPooledConnectionProvider provider) {
        super(provider);
    }

    @Override
    public <T> T executeCommand(CommandObject<T> commandObject) {
        MultiClusterPooledConnectionProvider.Cluster cluster = this.provider.getCluster();
        Decorators.DecorateSupplier supplier = Decorators.ofSupplier(() -> this.handleExecuteCommand(commandObject, cluster));
        supplier.withRetry(cluster.getRetry());
        supplier.withCircuitBreaker(cluster.getCircuitBreaker());
        supplier.withFallback(this.provider.getFallbackExceptionList(), e -> this.handleClusterFailover(commandObject, cluster.getCircuitBreaker()));
        return supplier.decorate().get();
    }

    private <T> T handleExecuteCommand(CommandObject<T> commandObject, MultiClusterPooledConnectionProvider.Cluster cluster) {
        try (Connection connection = cluster.getConnection();){
            T t = connection.executeCommand(commandObject);
            return t;
        }
    }

    private <T> T handleClusterFailover(CommandObject<T> commandObject, CircuitBreaker circuitBreaker) {
        this.clusterFailover(circuitBreaker);
        return this.executeCommand(commandObject);
    }
}

