/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class EditDecimalsCommand
extends AbstractCommand {
    public final EditCurrencyUseCase toggleFeaturesUseCase;

    public EditDecimalsCommand(EditCurrencyUseCase toggleFeaturesUseCase) {
        super("decimal", "", List.of("currency"));
        this.toggleFeaturesUseCase = toggleFeaturesUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String currencyName = args[0];
        try {
            this.toggleFeaturesUseCase.toggleDecimals(currencyName);
            sender.sendMessage("Toggled Decimal Support for " + currencyName);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("Unknown currency. " + currencyName);
        }
        catch (TransactionException e) {
            sender.sendMessage("Error toggling decimals for currency " + currencyName);
        }
        return true;
    }
}

