/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.components.abstractions;

import java.util.List;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IItemStack;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;

public abstract class PaginatedPanel<T>
extends AbstractPanel {
    protected int currentPage = 0;
    protected final int itemsPerPage;
    protected final int rows;

    public PaginatedPanel(String title, int rows, IEntityGUI player, IGUI parent, int itemsPerPage) {
        super(title, Math.max(3, rows), player, parent);
        this.rows = Math.max(3, rows);
        int availableRows = this.rows - 1;
        int maxSafeItems = availableRows * 7;
        this.itemsPerPage = Math.min(itemsPerPage, maxSafeItems);
    }

    protected void showItemsPage(List<T> items) {
        this.fill();
        if (items.isEmpty()) {
            this.setItem(this.getEmptyMessageSlot(), this.createEmptyMessage(), null);
            this.setItem(this.getBackButtonSlot(), this.createBackButton(), unused -> this.openParent());
            this.addCustomButtons();
            return;
        }
        int startIndex = this.currentPage * this.itemsPerPage;
        int endIndex = Math.min(startIndex + this.itemsPerPage, items.size());
        int slot = this.getStartingSlot();
        for (int i = startIndex; i < endIndex; ++i) {
            T item;
            T finalItem = item = items.get(i);
            this.setItem(slot, this.createItemFor(item), unused -> this.functionLeftItemClick(finalItem), unused -> this.functionRightItemClick(finalItem));
            slot = this.getNextSlot(slot);
        }
        if (this.currentPage > 0) {
            this.setItem(this.getPreviousButtonSlot(), this.createPreviousButton(), unused -> {
                --this.currentPage;
                this.showItemsPage(items);
            });
        }
        if (endIndex < items.size()) {
            this.setItem(this.getNextButtonSlot(), this.createNextButton(), unused -> {
                ++this.currentPage;
                this.showItemsPage(items);
            });
        }
        this.setItem(this.getBackButtonSlot(), this.createBackButton(), unused -> this.openParent());
        this.addCustomButtons();
    }

    protected abstract IItemStack createItemFor(T var1);

    protected void functionLeftItemClick(T item) {
    }

    protected void functionRightItemClick(T item) {
    }

    protected int getStartingSlot() {
        return 10;
    }

    protected int getNextSlot(int currentSlot) {
        if (++currentSlot % 9 == 8) {
            currentSlot += 2;
        }
        return currentSlot;
    }

    protected int getEmptyMessageSlot() {
        return this.rows * 9 / 2;
    }

    protected int getPreviousButtonSlot() {
        return (this.rows - 1) * 9 + 2;
    }

    protected int getNextButtonSlot() {
        return (this.rows - 1) * 9 + 6;
    }

    protected int getBackButtonSlot() {
        return (this.rows - 1) * 9 + 4;
    }

    protected IItemStack createEmptyMessage() {
        return this.createItem(Materials.BARRIER, "No Elements", "There are no items to display");
    }

    protected IItemStack createPreviousButton() {
        return this.createItem(Materials.ARROW, "Previous page", "Click to see previous items");
    }

    protected IItemStack createNextButton() {
        return this.createItem(Materials.ARROW, "Next Page", "Click to see more items");
    }

    protected IItemStack createBackButton() {
        return this.createItem(Materials.BARRIER, "Back", "Click to go back");
    }

    protected void addCustomButtons() {
    }
}

