/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.accounts;

import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.DepositUseCase;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.Context;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.abstractions.CurrencySelectorAndAmount;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class DepositPanel
extends CurrencySelectorAndAmount {
    private final DepositUseCase depositUseCase;
    private final Player targetPlayer;

    public DepositPanel(IEntityGUI player, Player targetPlayer, SearchCurrencyUseCase searchCurrencyUseCase, DepositUseCase depositUseCase, IGUI parentGUI, ITextInput textInput) {
        super(player, searchCurrencyUseCase, parentGUI, textInput);
        this.targetPlayer = targetPlayer;
        this.depositUseCase = depositUseCase;
    }

    @Override
    public String execute(IEntityGUI sender, Currency currency, BigDecimal amount) {
        Result<Void> result = this.depositUseCase.execute(this.targetPlayer.getUuid(), currency.getSingular(), amount, Context.COMMAND);
        if (result.isSuccess()) {
            sender.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Deposited " + ChatColor.stringValueOf(currency.getColor()) + currency.format(amount) + ChatColor.stringValueOf(Colors.GRAY) + " to " + this.targetPlayer.getNickname() + "'s account.");
            this.openParent();
            return null;
        }
        return result.getErrorMessage();
    }
}

