/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.currencies;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class EditCurrencyPanel
extends AbstractPanel {
    private final IEntityGUI player;
    private final Currency currency;
    private final EditCurrencyUseCase editCurrencyUseCase;
    private final ITextInput textInput;

    public EditCurrencyPanel(IEntityGUI player, Currency currency, EditCurrencyUseCase editCurrencyUseCase, IGUI parentGUI, ITextInput textInput) {
        super("Edit Currency: " + currency.getSingular(), 5, player, parentGUI);
        this.player = player;
        this.currency = currency;
        this.textInput = textInput;
        this.editCurrencyUseCase = editCurrencyUseCase;
        this.setupGUI();
    }

    private void setupGUI() {
        String color = ChatColor.stringValueOf(this.currency.getColor());
        this.setItem(4, this.createItem(Materials.GOLD_INGOT, color + this.currency.getSingular() + " / " + this.currency.getPlural(), "Symbol: " + color + this.currency.getSymbol(), "Color: " + color + this.currency.getColor(), "Beginning balance: " + color + String.valueOf(this.currency.getDefaultBalance()), "Exchange rate: " + color + this.currency.getExchangeRate(), "Transferable: " + (this.currency.isTransferable() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No"), "Default currency: " + (this.currency.isDefaultCurrency() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No"), "Supports decimals: " + (this.currency.isDecimalSupported() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No")), null);
        this.setItem(11, this.createItem(Materials.EMERALD_BLOCK, ChatColor.stringValueOf(Colors.GREEN) + "Edit Opening Balance", ChatColor.stringValueOf(Colors.GRAY) + "Click to modify the initial balance"), f -> this.openStartBalanceInput());
        this.setItem(13, this.createItem(Materials.GOLD_NUGGET, ChatColor.stringValueOf(Colors.YELLOW) + "Set Exchange Rate", ChatColor.stringValueOf(Colors.GRAY) + "Click to modify the exchange rate"), f -> this.openExchangeRateInput());
        this.setItem(15, this.createItem(Materials.LIME_DYE, ChatColor.stringValueOf(Colors.GREEN) + "Edit Color", ChatColor.stringValueOf(Colors.GRAY) + "Click to change the color of the currency"), f -> this.openColorSelectionGUI());
        this.setItem(20, this.createItem(Materials.NAME_TAG, ChatColor.stringValueOf(Colors.YELLOW) + "Edit Symbol", ChatColor.stringValueOf(Colors.GRAY) + "Click to change the currency symbol"), f -> this.openSymbolInput());
        this.setItem(22, this.createItem(Materials.NETHER_STAR, ChatColor.stringValueOf(Colors.YELLOW) + "Set as Default", ChatColor.stringValueOf(Colors.GRAY) + "Click to make this currency default"), f -> {
            try {
                this.editCurrencyUseCase.setDefaultCurrency(this.currency.getSingular());
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + this.currency.getSingular() + " is now the default currency.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
        });
        this.setItem(24, this.createItem(this.currency.isTransferable() ? Materials.LIME_CONCRETE : Materials.RED_CONCRETE, this.currency.isTransferable() ? "Transferable: " + ChatColor.stringValueOf(Colors.GREEN) + "Activated" : "Transferable: " + ChatColor.stringValueOf(Colors.RED) + "Disabled", ChatColor.stringValueOf(Colors.GRAY) + "Click to " + (this.currency.isTransferable() ? "Disable" : "Enable"), "This option affects:", "Transfer", "Pay", "Trade/Offers"), f -> {
            try {
                this.editCurrencyUseCase.togglePayable(this.currency.getSingular());
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Transfer option changed");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
        });
        this.setItem(29, this.createItem(Materials.PAPER, "Edit Singular Name", "Click to change the singular name"), f -> this.openSingularNameInput());
        this.setItem(31, this.createItem(Materials.BOOK, "Edit Plural Name", "Click to change the plural name"), f -> this.openPluralNameInput());
        this.setItem(33, this.createItem(this.currency.isDecimalSupported() ? Materials.LIME_CONCRETE : Materials.RED_CONCRETE, this.currency.isDecimalSupported() ? "Decimals support: " + ChatColor.stringValueOf(Colors.GREEN) + "Activated" : "Decimals support: " + ChatColor.stringValueOf(Colors.RED) + "Disabled", "Click to " + (this.currency.isDecimalSupported() ? "Disable" : "Enable") + " decimal support"), f -> {
            try {
                this.editCurrencyUseCase.toggleDecimals(this.currency.getSingular());
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] Decimal support changed.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
        });
        this.setItem(40, this.createItem(Materials.BARRIER, ChatColor.stringValueOf(Colors.RED) + "Back", ChatColor.stringValueOf(Colors.GRAY) + "Click to go back"), f -> GUIFactory.currencyListToEditPanel(this.player, this.getParent().getParent()).open());
    }

    private void openEditCurrencyGUI() {
        GUIFactory.editCurrencyPanel(this.player, this.currency, this.getParent()).open();
    }

    private void openColorSelectionGUI() {
        GUIFactory.colorSelectorPanel(this.player, this.currency, this).open();
    }

    private void openStartBalanceInput() {
        this.textInput.open(this, this.player, "Initial balance:" + this.currency.getSingular(), this.currency.getDefaultBalance().toString(), s -> {
            try {
                double startBal = Double.parseDouble(s);
                try {
                    this.editCurrencyUseCase.editStartBal(this.currency.getSingular(), startBal);
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Initial balance updated correctly.");
                    this.openEditCurrencyGUI();
                }
                catch (Exception e) {
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                    this.openEditCurrencyGUI();
                }
            }
            catch (NumberFormatException e) {
                return "Invalid format";
            }
            return null;
        });
    }

    private void openExchangeRateInput() {
        this.textInput.open(this, this.player, "Exchange rate:" + this.currency.getSingular(), String.valueOf(this.currency.getExchangeRate()), s -> {
            try {
                double rate = Double.parseDouble(s);
                try {
                    this.editCurrencyUseCase.setCurrencyRate(this.currency.getSingular(), rate);
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Exchange rate updated correctly.");
                    this.openEditCurrencyGUI();
                }
                catch (Exception e) {
                    this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                    this.openEditCurrencyGUI();
                }
            }
            catch (NumberFormatException e) {
                return "Invalid format";
            }
            return null;
        });
    }

    private void openSymbolInput() {
        this.textInput.open(this, this.player, "Symbol:" + this.currency.getSingular(), this.currency.getSymbol(), s -> {
            try {
                this.editCurrencyUseCase.editSymbol(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Symbol updated successfully.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
            return null;
        });
    }

    private void openSingularNameInput() {
        this.textInput.open(this, this.player, "Singular Name", this.currency.getSingular(), s -> {
            try {
                this.editCurrencyUseCase.setSingularName(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Singular name updated correctly.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
            return null;
        });
    }

    private void openPluralNameInput() {
        this.textInput.open(this, this.player, "Plural Name", this.currency.getPlural(), s -> {
            try {
                this.editCurrencyUseCase.setPluralName(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Plural noun updated correctly.");
                this.openEditCurrencyGUI();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + e.getMessage());
                this.openEditCurrencyGUI();
            }
            return null;
        });
    }
}

