/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users;

import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.PayUseCase;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.CurrencySelectorAndAmount;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class CurrencyListToPay
extends CurrencySelectorAndAmount {
    private final PayUseCase payUseCase;
    private final Player targetPlayer;

    public CurrencyListToPay(IEntityGUI player, Player targetPlayer, SearchCurrencyUseCase searchCurrencyUseCase, PayUseCase payUseCase, IGUI parentGUI, ITextInput textInput) {
        super(player, searchCurrencyUseCase, parentGUI, textInput);
        this.payUseCase = payUseCase;
        this.targetPlayer = targetPlayer;
    }

    @Override
    public String execute(IEntityGUI sender, Currency currency, BigDecimal amount) {
        Result<Void> result = this.payUseCase.execute(sender.getUniqueId(), this.targetPlayer.getUuid(), currency.getSingular(), amount);
        if (!result.isSuccess()) {
            return result.getErrorMessage();
        }
        return "Transaction Successful!";
    }

    @Override
    public void addCustomButtons() {
        this.setItem(4, this.createItem(Materials.PAPER, ChatColor.stringValueOf(Colors.GREEN) + "Select Currency to Pay", ChatColor.stringValueOf(Colors.WHITE) + "Click to select the currency you want to pay", ChatColor.stringValueOf(Colors.WHITE) + "And before that, the amount"), null);
    }
}

