/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users.Exchange;

import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.ExchangeUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import lib.gui.components.IEntityGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.CurrencySelectorAndAmount;
import lib.gui.templates.users.Exchange.ExchangeFirstPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class ExchangeSecondPanel
extends CurrencySelectorAndAmount {
    private final Currency currencyFrom;
    private final ExchangeUseCase exchangeUseCase;

    public ExchangeSecondPanel(IEntityGUI player, SearchCurrencyUseCase searchCurrencyUseCase, ExchangeUseCase exchangeUseCase, Currency currencyFrom, ExchangeFirstPanel parentGUI, ITextInput textInput) {
        super(player, searchCurrencyUseCase, parentGUI, currencyFrom, textInput);
        this.currencyFrom = currencyFrom;
        this.exchangeUseCase = exchangeUseCase;
    }

    @Override
    protected String execute(IEntityGUI sender, Currency currencyTo, BigDecimal amountTo) {
        Result<BigDecimal> result = this.exchangeUseCase.execute(sender.getUniqueId(), this.currencyFrom.getSingular(), currencyTo.getSingular(), null, amountTo);
        if (result.isSuccess()) {
            return "success";
        }
        return result.getErrorMessage();
    }

    @Override
    public void addCustomButtons() {
        this.setItem(4, this.createItem(Materials.PAPER, ChatColor.stringValueOf(Colors.GREEN) + "Select Currency you want to receive", ChatColor.stringValueOf(Colors.WHITE) + "Click to select the currency you want to receive", ChatColor.stringValueOf(Colors.WHITE) + "And before that, the amount"), null);
    }
}

