/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CoreTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.OverridingClassFileLocator;

public class ModelTypePool
extends TypePool.Default
implements EnhancerClassLocator {
    private final ConcurrentHashMap<String, TypePool.Resolution> resolutions = new ConcurrentHashMap();
    private final OverridingClassFileLocator locator;

    private ModelTypePool(TypePool.CacheProvider cacheProvider, OverridingClassFileLocator classFileLocator, CoreTypePool parent) {
        super(cacheProvider, classFileLocator, TypePool.Default.ReaderMode.FAST, parent);
        this.locator = classFileLocator;
    }

    public static EnhancerClassLocator buildModelTypePool(ClassLoader classLoader) {
        return ModelTypePool.buildModelTypePool(ClassFileLocator.ForClassLoader.of(classLoader));
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator) {
        return ModelTypePool.buildModelTypePool(classFileLocator, new CoreTypePool());
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator, CoreTypePool coreTypePool) {
        return ModelTypePool.buildModelTypePool(classFileLocator, coreTypePool, new TypePool.CacheProvider.Simple());
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator, CoreTypePool coreTypePool, TypePool.CacheProvider cacheProvider) {
        Objects.requireNonNull(classFileLocator);
        Objects.requireNonNull(coreTypePool);
        Objects.requireNonNull(cacheProvider);
        return new ModelTypePool(cacheProvider, new OverridingClassFileLocator(classFileLocator), coreTypePool);
    }

    @Override
    protected TypePool.Resolution doDescribe(String name) {
        TypePool.Resolution resolution = this.resolutions.get(name);
        if (resolution != null) {
            return resolution;
        }
        return this.resolutions.computeIfAbsent(name, x$0 -> super.doDescribe((String)x$0));
    }

    @Override
    public void registerClassNameAndBytes(String className, byte[] bytes) {
        this.locator.put(className, new ClassFileLocator.Resolution.Explicit(Objects.requireNonNull(bytes)));
    }

    @Override
    public void deregisterClassNameAndBytes(String className) {
        this.locator.remove(className);
    }

    @Override
    public ClassFileLocator asClassFileLocator() {
        return this.locator;
    }
}

