/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.SybaseAnywhereSqlAstTranslator;
import org.hibernate.community.dialect.identity.SybaseAnywhereIdentityColumnSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseAnywhereDialect
extends SybaseDialect {
    public SybaseAnywhereDialect() {
        this(DatabaseVersion.make(8));
    }

    public SybaseAnywhereDialect(DialectResolutionInfo info) {
        super(info);
    }

    public SybaseAnywhereDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case 2013: 
            case 2014: {
                return "timestamp with time zone";
            }
            case 4001: {
                return "long varchar";
            }
            case 4002: {
                return "long nvarchar";
            }
            case 4003: {
                return "long binary";
            }
            case 2011: {
                return "ntext";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.listagg_list("varchar");
        if (this.getVersion().isSameOrAfter(12)) {
            functionFactory.windowFunctions();
        }
    }

    @Override
    public int getMaxVarcharLength() {
        return Short.MAX_VALUE;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseAnywhereSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    public String currentDate() {
        return "current date";
    }

    @Override
    public String currentTime() {
        return "current time";
    }

    @Override
    public String currentTimestamp() {
        return "current timestamp";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "values (default)";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(12);
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(10);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return SybaseAnywhereIdentityColumnSupport.INSTANCE;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.getVersion().isSameOrAfter(10) ? RowLockStrategy.COLUMN : RowLockStrategy.TABLE;
    }

    @Override
    public String getForUpdateString() {
        return this.getVersion().isBefore(10) ? "" : " for update";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getVersion().isBefore(10) ? "" : this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String appendLockHint(LockOptions mode, String tableName) {
        return this.getVersion().isBefore(10) ? super.appendLockHint(mode, tableName) : tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return this.getVersion().isBefore(10) ? super.applyLocksToSql(sql, aliasedLockOptions, keyColumnNames) : sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }

    @Override
    public String getDual() {
        return "sys.dummy";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }
}

