/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.Remove;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public final class Versioning {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Versioning.class.getName());

    private Versioning() {
    }

    public static Object seed(EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        Object seed = versionMapping.getJavaType().seed(versionMapping.getLength(), versionMapping.getTemporalPrecision() != null ? versionMapping.getTemporalPrecision() : versionMapping.getPrecision(), versionMapping.getScale(), session);
        LOG.tracef("Seeding: %s", seed);
        return seed;
    }

    public static boolean seedVersion(Object entity, Object[] fields, EntityPersister persister, SharedSessionContractImplementor session) {
        int versionProperty = persister.getVersionProperty();
        Object initialVersion = fields[versionProperty];
        if (Versioning.isNullInitialVersion(initialVersion)) {
            fields[versionProperty] = persister.getVersionGenerator().generate(session, entity, initialVersion, EventType.INSERT);
            return true;
        }
        LOG.tracev("Using initial version: {0}", initialVersion);
        return false;
    }

    @Deprecated(since="6.2")
    @Remove
    public static boolean seedVersion(Object[] fields, int versionProperty, EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        Object initialVersion = fields[versionProperty];
        if (Versioning.isNullInitialVersion(initialVersion)) {
            fields[versionProperty] = Versioning.seed(versionMapping, session);
            return true;
        }
        LOG.tracev("Using initial version: {0}", initialVersion);
        return false;
    }

    public static boolean isNullInitialVersion(Object initialVersion) {
        return initialVersion == null || initialVersion instanceof Number && ((Number)initialVersion).longValue() < 0L;
    }

    public static Object incrementVersion(Object entity, Object currentVersion, EntityPersister persister, SharedSessionContractImplementor session) {
        return persister.getVersionGenerator().generate(session, entity, currentVersion, EventType.UPDATE);
    }

    public static Object increment(Object version, EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        JavaType versionType = versionMapping.getJavaType();
        Object next = versionType.next(version, versionMapping.getLength(), versionMapping.getTemporalPrecision() != null ? versionMapping.getTemporalPrecision() : versionMapping.getPrecision(), versionMapping.getScale(), session);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Incrementing: %s to %s", (Object)versionType.toString(version), (Object)versionType.toString(next));
        }
        return next;
    }

    public static void setVersion(Object[] fields, Object version, EntityPersister persister) {
        if (persister.isVersioned()) {
            fields[persister.getVersionProperty()] = version;
        }
    }

    public static Object getVersion(Object[] fields, EntityPersister persister) {
        return persister.isVersioned() ? fields[persister.getVersionProperty()] : null;
    }

    public static boolean isVersionIncrementRequired(int[] dirtyProperties, boolean hasDirtyCollections, boolean[] propertyVersionability) {
        if (hasDirtyCollections) {
            return true;
        }
        if (dirtyProperties != null) {
            for (int dirtyProperty : dirtyProperties) {
                if (!propertyVersionability[dirtyProperty]) continue;
                return true;
            }
        }
        return false;
    }
}

