/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Incubating;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.jboss.logging.Logger;

public class EffectiveEntityGraph
implements AppliedGraph,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(EffectiveEntityGraph.class);
    private final @UnknownKeyFor @NonNull @Initialized boolean allowOverwrite;
    private @Nullable @UnknownKeyFor @Initialized GraphSemantic semantic;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> graph;

    @Incubating
    public EffectiveEntityGraph() {
        this(false);
    }

    @Incubating
    public EffectiveEntityGraph(@UnknownKeyFor @NonNull @Initialized boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized GraphSemantic getSemantic() {
        return this.semantic;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getGraph() {
        return this.graph;
    }

    public void applyGraph(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> graph, @Nullable @UnknownKeyFor @Initialized GraphSemantic semantic) {
        if (semantic == null) {
            throw new IllegalArgumentException("Graph semantic cannot be null");
        }
        this.verifyWriteability();
        log.debugf("Setting effective graph state [%s] : %s", (Object)semantic.name(), (Object)graph);
        this.semantic = semantic;
        this.graph = graph;
    }

    private void verifyWriteability() {
        if (!this.allowOverwrite && this.semantic != null) {
            throw new IllegalStateException("Cannot overwrite existing state, should clear previous state first");
        }
    }

    public void applyConfiguredGraph(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        RootGraphImplementor fetchHint = (RootGraphImplementor)properties.get(GraphSemantic.FETCH.getJpaHintName());
        RootGraphImplementor loadHint = (RootGraphImplementor)properties.get(GraphSemantic.LOAD.getJpaHintName());
        if (fetchHint == null) {
            fetchHint = (RootGraphImplementor)properties.get(GraphSemantic.FETCH.getJakartaHintName());
        }
        if (loadHint == null) {
            loadHint = (RootGraphImplementor)properties.get(GraphSemantic.LOAD.getJakartaHintName());
        }
        if (fetchHint == null && loadHint == null) {
            log.debugf("Neither LOAD nor FETCH graph were found in properties", new Object[0]);
            return;
        }
        if (fetchHint != null) {
            if (loadHint != null) {
                throw new IllegalArgumentException("Passed properties contained both a LOAD and a FETCH graph which is illegal - only one should be passed");
            }
            this.applyGraph(fetchHint, GraphSemantic.FETCH);
        } else {
            assert (loadHint != null) : "@AssumeAssertion(nullness)";
            this.applyGraph(loadHint, GraphSemantic.LOAD);
        }
    }

    public void clear() {
        this.semantic = null;
        this.graph = null;
    }
}

