/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.transaction.xa.XAResource;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;

public class WebSphereExtendedJtaPlatform
extends AbstractJtaPlatform {
    public static final @UnknownKeyFor @NonNull @Initialized String UT_NAME = "java:comp/UserTransaction";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized boolean canCacheTransactionManager() {
        return true;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager() {
        return new TransactionManagerAdapter();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction() {
        return (UserTransaction)this.jndiService().locate(UT_NAME);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object getTransactionIdentifier(@UnknownKeyFor @NonNull @Initialized Transaction transaction) {
        return transaction.hashCode();
    }

    public class TransactionManagerAdapter
    implements TransactionManager {
        private final @UnknownKeyFor @NonNull @Initialized Class synchronizationCallbackClass;
        private final @UnknownKeyFor @NonNull @Initialized Method registerSynchronizationMethod;
        private final @UnknownKeyFor @NonNull @Initialized Method getLocalIdMethod;
        private @UnknownKeyFor @NonNull @Initialized Object extendedJTATransaction;

        private TransactionManagerAdapter() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
            try {
                this.synchronizationCallbackClass = Class.forName("com.ibm.websphere.jtaextensions.SynchronizationCallback");
                Class<?> extendedJTATransactionClass = Class.forName("com.ibm.websphere.jtaextensions.ExtendedJTATransaction");
                this.registerSynchronizationMethod = extendedJTATransactionClass.getMethod("registerSynchronizationCallbackForCurrentTran", this.synchronizationCallbackClass);
                this.getLocalIdMethod = extendedJTATransactionClass.getMethod("getLocalId", null);
            }
            catch (ClassNotFoundException cnfe) {
                throw new HibernateException(cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new HibernateException(nsme);
            }
        }

        @Override
        public void begin() throws @UnknownKeyFor @NonNull @Initialized NotSupportedException, @UnknownKeyFor @NonNull @Initialized SystemException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void commit() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getStatus() throws @UnknownKeyFor @NonNull @Initialized SystemException {
            return this.getTransaction() == null ? 6 : this.getTransaction().getStatus();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Transaction getTransaction() throws @UnknownKeyFor @NonNull @Initialized SystemException {
            return new TransactionAdapter();
        }

        @Override
        public void resume(@UnknownKeyFor @NonNull @Initialized Transaction txn) throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rollback() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRollbackOnly() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTransactionTimeout(@UnknownKeyFor @NonNull @Initialized int i) throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Transaction suspend() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public class TransactionAdapter
        implements Transaction {
            private TransactionAdapter() {
                if (TransactionManagerAdapter.this.extendedJTATransaction == null) {
                    TransactionManagerAdapter.this.extendedJTATransaction = WebSphereExtendedJtaPlatform.this.jndiService().locate("java:comp/websphere/ExtendedJTATransaction");
                }
            }

            @Override
            public void registerSynchronization(final @UnknownKeyFor @NonNull @Initialized Synchronization synchronization) throws @UnknownKeyFor @NonNull @Initialized RollbackException, @UnknownKeyFor @NonNull @Initialized IllegalStateException, @UnknownKeyFor @NonNull @Initialized SystemException {
                InvocationHandler ih = new InvocationHandler(){

                    @Override
                    public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("afterCompletion".equals(method.getName())) {
                            int status = args[2].equals(Boolean.TRUE) ? 3 : 5;
                            synchronization.afterCompletion(status);
                        } else if ("beforeCompletion".equals(method.getName())) {
                            synchronization.beforeCompletion();
                        } else if ("toString".equals(method.getName())) {
                            return synchronization.toString();
                        }
                        return null;
                    }
                };
                Object synchronizationCallback = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TransactionManagerAdapter.this.synchronizationCallbackClass}, ih);
                try {
                    TransactionManagerAdapter.this.registerSynchronizationMethod.invoke(TransactionManagerAdapter.this.extendedJTATransaction, synchronizationCallback);
                }
                catch (Exception e) {
                    throw new HibernateException(e);
                }
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return this.getLocalId().hashCode();
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
                if (!(other instanceof TransactionAdapter)) {
                    return false;
                }
                TransactionAdapter that = (TransactionAdapter)other;
                return this.getLocalId().equals(that.getLocalId());
            }

            private @UnknownKeyFor @NonNull @Initialized Object getLocalId() throws @UnknownKeyFor @NonNull @Initialized HibernateException {
                try {
                    return TransactionManagerAdapter.this.getLocalIdMethod.invoke(TransactionManagerAdapter.this.extendedJTATransaction, (Object[])null);
                }
                catch (Exception e) {
                    throw new HibernateException(e);
                }
            }

            @Override
            public void commit() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean delistResource(@UnknownKeyFor @NonNull @Initialized XAResource resource, @UnknownKeyFor @NonNull @Initialized int i) throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean enlistResource(@UnknownKeyFor @NonNull @Initialized XAResource resource) throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized int getStatus() {
                return Integer.valueOf(0).equals(this.getLocalId()) ? 6 : 0;
            }

            @Override
            public void rollback() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setRollbackOnly() throws @UnknownKeyFor @NonNull @Initialized UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

