/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultPersistEventListener
extends AbstractSaveEventListener<PersistContext>
implements PersistEventListener,
CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultPersistEventListener.class);

    @Override
    protected CascadingAction<PersistContext> getCascadeAction() {
        return CascadingActions.PERSIST;
    }

    @Override
    public void onPersist(PersistEvent event) throws HibernateException {
        this.onPersist(event, PersistContext.create());
    }

    @Override
    public void onPersist(PersistEvent event, PersistContext createCache) throws HibernateException {
        Object object = event.getObject();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                if (lazyInitializer.getSession() != event.getSession()) {
                    throw new PersistentObjectException("uninitialized proxy passed to persist()");
                }
            } else {
                this.persist(event, createCache, lazyInitializer.getImplementation());
            }
        } else {
            this.persist(event, createCache, object);
        }
    }

    private void persist(PersistEvent event, PersistContext createCache, Object entity) {
        EventSource source = event.getSession();
        EntityEntry entityEntry = source.getPersistenceContextInternal().getEntry(entity);
        String entityName = DefaultPersistEventListener.entityName(event, entity, entityEntry);
        switch (DefaultPersistEventListener.entityState(event, entity, entityName, entityEntry)) {
            case DETACHED: {
                throw new PersistentObjectException("detached entity passed to persist: " + EventUtil.getLoggableName(event.getEntityName(), entity));
            }
            case PERSISTENT: {
                this.entityIsPersistent(event, createCache);
                break;
            }
            case TRANSIENT: {
                this.entityIsTransient(event, createCache);
                break;
            }
            case DELETED: {
                entityEntry.setStatus(Status.MANAGED);
                entityEntry.setDeletedState(null);
                source.getActionQueue().unScheduleDeletion(entityEntry, event.getObject());
                this.entityIsDeleted(event, createCache);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to persist", null, EventUtil.getLoggableName(event.getEntityName(), entity));
            }
        }
    }

    private static EntityState entityState(PersistEvent event, Object entity, String entityName, EntityEntry entityEntry) {
        EntityPersister persister;
        EventSource source = event.getSession();
        EntityState entityState = EntityState.getEntityState(entity, entityName, entityEntry, source, true);
        if (entityState == EntityState.DETACHED && (persister = event.getFactory().getMappingMetamodel().getEntityDescriptor(entityName)).getGenerator() instanceof ForeignGenerator) {
            if (LOG.isDebugEnabled() && persister.getIdentifier(entity, source) != null) {
                LOG.debug("Resetting entity id attribute to null for foreign generator");
            }
            persister.setIdentifier(entity, null, source);
            entityState = EntityState.getEntityState(entity, entityName, entityEntry, source, true);
        }
        return entityState;
    }

    private static String entityName(PersistEvent event, Object entity, EntityEntry entityEntry) {
        if (event.getEntityName() != null) {
            return event.getEntityName();
        }
        String entityName = event.getSession().bestGuessEntityName(entity, entityEntry);
        event.setEntityName(entityName);
        return entityName;
    }

    protected void entityIsPersistent(PersistEvent event, PersistContext createCache) {
        LOG.trace("Ignoring persistent instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        if (createCache.add(entity)) {
            this.justCascade(createCache, source, entity, source.getEntityPersister(event.getEntityName(), entity));
        }
    }

    private void justCascade(PersistContext createCache, EventSource source, Object entity, EntityPersister persister) {
        this.cascadeBeforeSave(source, persister, entity, createCache);
        this.cascadeAfterSave(source, persister, entity, createCache);
    }

    protected void entityIsTransient(PersistEvent event, PersistContext createCache) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        if (createCache.add(entity)) {
            this.saveWithGeneratedId(entity, event.getEntityName(), createCache, source, false);
        }
    }

    private void entityIsDeleted(PersistEvent event, PersistContext createCache) {
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("un-scheduling entity deletion [%s]", (Object)MessageHelper.infoString(persister, persister.getIdentifier(entity, source), event.getFactory()));
        }
        if (createCache.add(entity)) {
            this.justCascade(createCache, source, entity, persister);
        }
    }
}

