/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.ValueClassification;
import org.hibernate.metamodel.internal.AttributeContext;
import org.hibernate.metamodel.internal.AttributeMetadata;
import org.hibernate.metamodel.internal.MemberResolver;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.PluralAttributeMetadata;
import org.hibernate.metamodel.internal.PluralAttributeMetadataImpl;
import org.hibernate.metamodel.internal.SingularAttributeMetadata;
import org.hibernate.metamodel.internal.SingularAttributeMetadataImpl;
import org.hibernate.metamodel.internal.ValueContext;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AnyMappingDomainTypeImpl;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MapMember;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessMapImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class AttributeFactory {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(AttributeFactory.class);
    private final MetadataContext context;
    private static final MemberResolver embeddedMemberResolver = (attributeContext, metadataContext) -> {
        EmbeddableDomainType ownerType = (EmbeddableDomainType)attributeContext.getOwnerType();
        return AttributeFactory.resolveEmbeddedMember(attributeContext.getPropertyMapping(), ownerType, metadataContext);
    };
    private static final MemberResolver virtualIdentifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister declaringEntity = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        return AttributeFactory.resolveVirtualIdentifierMember(attributeContext.getPropertyMapping(), declaringEntity);
    };
    private static final MemberResolver normalMemberResolver = (attributeContext, metadataContext) -> {
        ManagedDomainType ownerType = attributeContext.getOwnerType();
        Property property = attributeContext.getPropertyMapping();
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (Type.PersistenceType.EMBEDDABLE == persistenceType) {
            return embeddedMemberResolver.resolveMember(attributeContext, metadataContext);
        }
        if (Type.PersistenceType.MAPPED_SUPERCLASS == persistenceType) {
            return AttributeFactory.resolveMappedSuperclassMember(property, (MappedSuperclassDomainType)ownerType, metadataContext);
        }
        if (Type.PersistenceType.ENTITY == persistenceType) {
            return AttributeFactory.resolveEntityMember(property, AttributeFactory.getDeclaringEntity((AbstractIdentifiableType)ownerType, metadataContext));
        }
        throw new IllegalArgumentException("Unexpected owner type : " + persistenceType);
    };
    private final MemberResolver identifierMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister declaringEntityMapping = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityIdentifierMapping identifierMapping = declaringEntityMapping.getIdentifierMapping();
        Property propertyMapping = attributeContext.getPropertyMapping();
        if (!propertyMapping.getName().equals(identifierMapping.getAttributeName())) {
            return virtualIdentifierMemberResolver.resolveMember(attributeContext, metadataContext);
        }
        Getter getter = AttributeFactory.getter(declaringEntityMapping, propertyMapping);
        if (getter instanceof PropertyAccessMapImpl.GetterImpl) {
            return new MapMember(identifierMapping.getAttributeName(), identifierMapping.getJavaType().getJavaTypeClass());
        }
        return getter.getMember();
    };
    private final MemberResolver versionMemberResolver = (attributeContext, metadataContext) -> {
        AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
        EntityPersister entityPersister = AttributeFactory.getDeclaringEntity(identifiableType, metadataContext);
        EntityVersionMapping versionMapping = entityPersister.getVersionMapping();
        assert (entityPersister.isVersioned());
        assert (versionMapping != null);
        String versionPropertyName = attributeContext.getPropertyMapping().getName();
        if (!versionPropertyName.equals(versionMapping.getVersionAttribute().getAttributeName())) {
            throw new IllegalArgumentException("Given property did not match declared version property");
        }
        Getter getter = AttributeFactory.getter(entityPersister, attributeContext.getPropertyMapping());
        if (getter instanceof PropertyAccessMapImpl.GetterImpl) {
            return new MapMember(versionPropertyName, versionMapping.getJavaType().getJavaTypeClass());
        }
        return getter.getMember();
    };

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property) {
        return AttributeFactory.buildAttribute(ownerType, property, this.context);
    }

    public static <X, Y> PersistentAttribute<X, Y> buildAttribute(ManagedDomainType<X> ownerType, Property property, MetadataContext metadataContext) {
        if (property.isSynthetic()) {
            LOG.tracef("Skipping synthetic property %s(%s)", (Object)ownerType.getTypeName(), (Object)property.getName());
            return null;
        }
        LOG.tracef("Building attribute [%s.%s]", (Object)ownerType.getTypeName(), (Object)property.getName());
        AttributeContext<X> attributeContext = AttributeFactory.wrap(ownerType, property);
        AttributeMetadata<X, Y> attributeMetadata = AttributeFactory.determineAttributeMetadata(attributeContext, normalMemberResolver, metadataContext);
        if (attributeMetadata instanceof PluralAttributeMetadata) {
            return PluralAttributeBuilder.build((PluralAttributeMetadata)attributeMetadata, property.isGeneric(), metadataContext);
        }
        ValueContext valueContext = ((SingularAttributeMetadata)attributeMetadata).getValueContext();
        DomainType<Y> metaModelType = AttributeFactory.determineSimpleType(valueContext, metadataContext);
        JavaType<?> relationalJavaType = AttributeFactory.determineRelationalJavaType(valueContext, metaModelType, metadataContext);
        return new SingularAttributeImpl<X, Y>(ownerType, attributeMetadata.getName(), attributeMetadata.getAttributeClassification(), metaModelType, relationalJavaType, attributeMetadata.getMember(), false, false, property.isOptional(), property.isGeneric(), metadataContext);
    }

    private static <X> AttributeContext<X> wrap(final ManagedDomainType<X> ownerType, final Property property) {
        return new AttributeContext<X>(){

            @Override
            public ManagedDomainType<X> getOwnerType() {
                return ownerType;
            }

            @Override
            public Property getPropertyMapping() {
                return property;
            }
        };
    }

    public <X, Y> SingularPersistentAttribute<X, Y> buildIdAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        LOG.tracef("Building identifier attribute [%s.%s]", (Object)ownerType.getTypeName(), (Object)property.getName());
        AttributeMetadata<X, Y> attributeMetadata = this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.identifierMemberResolver);
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        DomainType<Y> domainType = this.determineSimpleType(singularAttributeMetadata.getValueContext());
        return new SingularAttributeImpl.Identifier(ownerType, property.getName(), (SimpleDomainType)domainType, attributeMetadata.getMember(), attributeMetadata.getAttributeClassification(), property.isGeneric(), this.context);
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(IdentifiableDomainType<X> ownerType, Property property) {
        LOG.tracef("Building version attribute [%s.%s]", (Object)ownerType.getTypeName(), (Object)property.getName());
        AttributeMetadata<X, Y> attributeMetadata = this.determineAttributeMetadata(AttributeFactory.wrap(ownerType, property), this.versionMemberResolver);
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        DomainType<Y> domainType = this.determineSimpleType(singularAttributeMetadata.getValueContext());
        return new SingularAttributeImpl.Version(ownerType, property.getName(), attributeMetadata.getAttributeClassification(), (SimpleDomainType)domainType, attributeMetadata.getMember(), this.context);
    }

    private <Y> DomainType<Y> determineSimpleType(ValueContext typeContext) {
        return AttributeFactory.determineSimpleType(typeContext, this.context);
    }

    public static <Y> DomainType<Y> determineSimpleType(ValueContext typeContext, MetadataContext context) {
        switch (typeContext.getValueClassification()) {
            case BASIC: {
                return AttributeFactory.basicDomainType(typeContext, context);
            }
            case ENTITY: {
                return AttributeFactory.entityDomainType(typeContext, context);
            }
            case EMBEDDABLE: {
                return AttributeFactory.embeddableDomainType(typeContext, context);
            }
        }
        throw new AssertionFailure("Unknown type : " + typeContext.getValueClassification());
    }

    private static <Y> EmbeddableDomainType<Y> embeddableDomainType(ValueContext typeContext, MetadataContext context) {
        Component component = (Component)typeContext.getHibernateValue();
        if (component.isDynamic()) {
            return AttributeFactory.dynamicEmbeddableType(context, component);
        }
        return AttributeFactory.classEmbeddableType(context, component);
    }

    private static <Y> EmbeddableDomainType<Y> classEmbeddableType(MetadataContext context, Component component) {
        EmbeddableDomainType<?> cached;
        assert (component.getComponentClassName() != null);
        Class<?> embeddableClass = component.getComponentClass();
        if (!component.isGeneric() && (cached = context.locateEmbeddable(embeddableClass, component)) != null) {
            return cached;
        }
        MappedSuperclass mappedSuperclass = component.getMappedSuperclass();
        MappedSuperclassDomainType<?> superType = mappedSuperclass != null ? context.locateMappedSuperclassType(mappedSuperclass) : null;
        DiscriminatorType<?> discriminatorType = component.isPolymorphic() ? component.getDiscriminatorType() : null;
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(context.getJavaTypeRegistry().resolveManagedTypeDescriptor(embeddableClass), superType, discriminatorType, false, context.getJpaMetamodel());
        context.registerEmbeddableType(embeddableType, component);
        if (component.isPolymorphic()) {
            Collection<String> embeddableSubclasses = component.getDiscriminatorValues().values();
            HashMap domainTypes = new HashMap();
            domainTypes.put(embeddableType.getTypeName(), embeddableType);
            ClassLoaderService cls = context.getJpaMetamodel().getServiceRegistry().requireService(ClassLoaderService.class);
            for (String subclassName : embeddableSubclasses) {
                if (domainTypes.containsKey(subclassName)) {
                    assert (subclassName.equals(embeddableType.getTypeName()));
                    continue;
                }
                Class subclass = cls.classForName(subclassName);
                EmbeddableTypeImpl subType = new EmbeddableTypeImpl(context.getJavaTypeRegistry().resolveManagedTypeDescriptor(subclass), (ManagedDomainType)domainTypes.get(component.getSuperclass(subclassName)), discriminatorType, false, context.getJpaMetamodel());
                domainTypes.put(subclassName, subType);
                context.registerEmbeddableType(subType, component);
            }
        }
        return embeddableType;
    }

    private static <Y> EmbeddableTypeImpl<Y> dynamicEmbeddableType(MetadataContext context, Component component) {
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(context.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)java.util.Map.class)), null, null, true, context.getJpaMetamodel());
        context.registerComponentByEmbeddable(embeddableType, component);
        AttributeContainer.InFlightAccess inFlightAccess = embeddableType.getInFlightAccess();
        for (Property property : component.getProperties()) {
            PersistentAttribute attribute = AttributeFactory.buildAttribute(embeddableType, property, context);
            if (attribute == null) continue;
            inFlightAccess.addAttribute(attribute);
        }
        inFlightAccess.finishUp();
        return embeddableType;
    }

    private static <Y> DomainType<Y> entityDomainType(ValueContext typeContext, MetadataContext context) {
        Type type = typeContext.getHibernateValue().getType();
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            IdentifiableDomainType domainType = context.locateIdentifiableType(entityType.getAssociatedEntityName());
            if (domainType == null) {
                JavaType domainJavaType = context.getJavaTypeRegistry().resolveDescriptor(typeContext.getJpaBindableType());
                return new EntityTypeImpl(domainJavaType, context.getJpaMetamodel());
            }
            return domainType;
        }
        assert (type instanceof AnyType);
        AnyType anyType = (AnyType)type;
        return new AnyMappingDomainTypeImpl((Any)typeContext.getHibernateValue(), anyType, context.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(anyType.getReturnedClass()), context.getRuntimeModelCreationContext().getSessionFactory().getMappingMetamodel());
    }

    private static <Y> DomainType<Y> basicDomainType(ValueContext typeContext, MetadataContext context) {
        JavaType javaTypeDescriptor;
        Value hibernateValue = typeContext.getHibernateValue();
        if (typeContext.getJpaBindableType().isPrimitive() && ((SimpleValue)hibernateValue).getJpaAttributeConverterDescriptor() == null) {
            Class<?> type = typeContext.getJpaBindableType();
            return context.resolveBasicType(type);
        }
        Type type = hibernateValue.getType();
        if (type instanceof BasicPluralType && (javaTypeDescriptor = ((BasicPluralType)type).getElementType().getJavaTypeDescriptor()) instanceof EmbeddableAggregateJavaType) {
            AggregateColumn aggregateColumn = (AggregateColumn)hibernateValue.getColumns().get(0);
            AttributeFactory.classEmbeddableType(context, aggregateColumn.getComponent());
        }
        return (DomainType)((Object)type);
    }

    private static JavaType<?> determineRelationalJavaType(ValueContext typeContext, DomainType<?> metaModelType, MetadataContext context) {
        ConverterDescriptor descriptor;
        if (typeContext.getValueClassification() == ValueClassification.BASIC && (descriptor = ((SimpleValue)typeContext.getHibernateValue()).getJpaAttributeConverterDescriptor()) != null) {
            return context.getJavaTypeRegistry().resolveDescriptor(descriptor.getRelationalValueResolvedType().getErasedType());
        }
        return metaModelType.getExpressibleJavaType();
    }

    private static EntityPersister getDeclaringEntity(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        return AttributeFactory.getDeclarerEntityPersister(ownerType, metadataContext);
    }

    private static EntityPersister getDeclarerEntityPersister(AbstractIdentifiableType<?> ownerType, MetadataContext metadataContext) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return metadataContext.getMetamodel().getEntityDescriptor(ownerType.getTypeName());
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = metadataContext.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return persistentClass != null ? metadataContext.getMetamodel().findEntityDescriptor(persistentClass.getClassName()) : null;
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + persistenceType);
    }

    private <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver) {
        return AttributeFactory.determineAttributeMetadata(attributeContext, memberResolver, this.context);
    }

    private static <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver, MetadataContext context) {
        Property propertyMapping = attributeContext.getPropertyMapping();
        String propertyName = propertyMapping.getName();
        LOG.tracef("Starting attribute metadata determination [%s]", (Object)propertyName);
        Member member = memberResolver.resolveMember(attributeContext, context);
        LOG.tracef("    Determined member [%s]", (Object)member);
        Value value = propertyMapping.getValue();
        Type type = value.getType();
        LOG.tracef("    Determined type [name=%s, class=%s]", (Object)type.getName(), (Object)type.getClass().getName());
        if (type instanceof AnyType) {
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.ANY, context);
        }
        if (type instanceof EntityType) {
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeFactory.determineSingularAssociationClassification(member), context);
        }
        if (type instanceof CollectionType) {
            if (value instanceof org.hibernate.mapping.Collection) {
                org.hibernate.mapping.Collection collValue = (org.hibernate.mapping.Collection)value;
                Value elementValue = collValue.getElement();
                Type elementType = elementValue.getType();
                boolean isManyToMany = AttributeFactory.isManyToMany(member);
                return new PluralAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeFactory.collectionClassification(elementType, elementValue, isManyToMany), AttributeFactory.elementClassification(elementType, elementValue, isManyToMany), AttributeFactory.indexClassification(value), context);
            }
            if (value instanceof OneToMany) {
                throw new AssertionFailure("Unexpected OneToMany");
            }
        } else {
            if (type instanceof ComponentType) {
                return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.EMBEDDED, context);
            }
            assert (type instanceof BasicType);
            return new SingularAttributeMetadataImpl(propertyMapping, attributeContext.getOwnerType(), member, AttributeClassification.BASIC, context);
        }
        throw new UnsupportedMappingException("oops, we are missing something: " + propertyMapping);
    }

    private static AttributeClassification indexClassification(Value value) {
        if (value instanceof Map) {
            Value keyValue = ((Map)value).getIndex();
            return AttributeFactory.keyClassification(keyValue.getType(), keyValue);
        }
        if (value instanceof List) {
            return AttributeClassification.BASIC;
        }
        return null;
    }

    private static AttributeClassification elementClassification(Type elementType, Value elementValue, boolean isManyToMany) {
        if (elementType instanceof AnyType) {
            return AttributeClassification.ANY;
        }
        if (elementType instanceof ComponentType) {
            return AttributeClassification.EMBEDDED;
        }
        if (elementType instanceof EntityType) {
            return isManyToMany ? AttributeClassification.MANY_TO_MANY : AttributeClassification.ONE_TO_MANY;
        }
        return AttributeClassification.BASIC;
    }

    private static AttributeClassification collectionClassification(Type elementType, Value elementValue, boolean isManyToMany) {
        if (elementType instanceof EntityType) {
            return isManyToMany ? AttributeClassification.MANY_TO_MANY : AttributeClassification.ONE_TO_MANY;
        }
        return AttributeClassification.ELEMENT_COLLECTION;
    }

    private static AttributeClassification keyClassification(Type keyType, Value keyValue) {
        if (keyType instanceof AnyType) {
            return AttributeClassification.ANY;
        }
        if (keyType instanceof ComponentType) {
            return AttributeClassification.EMBEDDED;
        }
        if (keyType instanceof EntityType) {
            return AttributeClassification.MANY_TO_ONE;
        }
        return AttributeClassification.BASIC;
    }

    public static AttributeClassification determineSingularAssociationClassification(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
        }
        if (member instanceof MapMember) {
            return AttributeClassification.MANY_TO_ONE;
        }
        return ((Method)member).getAnnotation(OneToOne.class) != null ? AttributeClassification.ONE_TO_ONE : AttributeClassification.MANY_TO_ONE;
    }

    public static ParameterizedType getSignatureType(Member member) {
        java.lang.reflect.Type type = member instanceof Field ? ((Field)member).getGenericType() : (member instanceof Method ? ((Method)member).getGenericReturnType() : ((MapMember)member).getType());
        if (type instanceof Class) {
            return null;
        }
        return (ParameterizedType)type;
    }

    public static boolean isManyToMany(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(ManyToMany.class) != null;
        }
        if (member instanceof Method) {
            return ((Method)member).getAnnotation(ManyToMany.class) != null;
        }
        return false;
    }

    private static Member resolveEmbeddedMember(Property property, EmbeddableDomainType<?> ownerType, MetadataContext metadataContext) {
        Component ownerBootDescriptor = metadataContext.getEmbeddableBootDescriptor(ownerType);
        CompositeTypeImplementor ownerComponentType = (CompositeTypeImplementor)ownerBootDescriptor.getType();
        EmbeddableValuedModelPart ownerMappingModelDescriptor = ownerComponentType.getMappingModelPart();
        EmbeddableRepresentationStrategy ownerRepStrategy = AttributeFactory.ownerRepresentationStrategy(metadataContext, ownerMappingModelDescriptor, ownerBootDescriptor);
        if (ownerRepStrategy.getMode() == RepresentationMode.MAP) {
            return new MapMember(property.getName(), property.getType().getReturnedClass());
        }
        return ownerRepStrategy.resolvePropertyAccess(property).getGetter().getMember();
    }

    private static EmbeddableRepresentationStrategy ownerRepresentationStrategy(MetadataContext metadataContext, EmbeddableValuedModelPart ownerMappingModelDescriptor, Component ownerBootDescriptor) {
        if (ownerMappingModelDescriptor == null) {
            return ownerBootDescriptor.getBuildingContext().getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(ownerBootDescriptor, null, metadataContext.getRuntimeModelCreationContext());
        }
        return ownerMappingModelDescriptor.getEmbeddableTypeDescriptor().getRepresentationStrategy();
    }

    private static Member resolveVirtualIdentifierMember(Property property, EntityPersister entityPersister) {
        String attributeName;
        EntityIdentifierMapping identifierMapping = entityPersister.getIdentifierMapping();
        if (identifierMapping.getNature() != EntityIdentifierMapping.Nature.VIRTUAL) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        CompositeIdentifierMapping cid = (CompositeIdentifierMapping)identifierMapping;
        EmbeddableMappingType embeddable = cid.getPartMappingType();
        AttributeMapping attributeMapping = embeddable.findAttributeMapping(attributeName = property.getName());
        if (attributeMapping == null) {
            throw new PropertyNotFoundException("Could not resolve attribute '" + attributeName + "' of '" + embeddable.getJavaType().getJavaTypeClass().getName() + "'");
        }
        Getter getter = attributeMapping.getPropertyAccess().getGetter();
        return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(attributeName, property.getType().getReturnedClass()) : getter.getMember();
    }

    private static Member resolveEntityMember(Property property, EntityPersister declaringEntity) {
        String propertyName = property.getName();
        AttributeMapping attributeMapping = declaringEntity.findAttributeMapping(propertyName);
        if (attributeMapping == null) {
            return AttributeFactory.resolveVirtualIdentifierMember(property, declaringEntity);
        }
        Getter getter = AttributeFactory.getter(declaringEntity, property);
        return getter instanceof PropertyAccessMapImpl.GetterImpl ? new MapMember(propertyName, property.getType().getReturnedClass()) : getter.getMember();
    }

    private static Member resolveMappedSuperclassMember(Property property, MappedSuperclassDomainType<?> ownerType, MetadataContext metadataContext) {
        EntityPersister declaringEntity = AttributeFactory.getDeclaringEntity((AbstractIdentifiableType)((Object)ownerType), metadataContext);
        if (declaringEntity != null) {
            return AttributeFactory.resolveEntityMember(property, declaringEntity);
        }
        ManagedDomainType subType = ownerType.getSubTypes().iterator().next();
        Type.PersistenceType persistenceType = subType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return AttributeFactory.resolveEntityMember(property, AttributeFactory.getDeclaringEntity((AbstractIdentifiableType)subType, metadataContext));
        }
        if (persistenceType == Type.PersistenceType.EMBEDDABLE) {
            return AttributeFactory.resolveEmbeddedMember(property, (EmbeddableDomainType)subType, metadataContext);
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            return AttributeFactory.resolveMappedSuperclassMember(property, (MappedSuperclassDomainType)subType, metadataContext);
        }
        throw new IllegalArgumentException("Unexpected sub-type: " + persistenceType);
    }

    private static Getter getter(EntityPersister declaringEntityMapping, Property propertyMapping) {
        return declaringEntityMapping.getRepresentationStrategy().resolvePropertyAccess(propertyMapping).getGetter();
    }
}

