/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class DomainPathPart
implements SemanticPathPart {
    private SqmPath<?> currentPath;

    public DomainPathPart(SqmPath<?> basePath) {
        this.currentPath = basePath;
        assert (this.currentPath != null);
    }

    SqmExpression<?> getSqmExpression() {
        return this.currentPath;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        HqlLogging.QUERY_LOGGER.tracef("Resolving DomainPathPart(%s) sub-part : %s", (Object)this.currentPath, (Object)name);
        this.currentPath = this.currentPath.resolvePathPart(name, isTerminal, creationState);
        if (isTerminal) {
            return this.currentPath;
        }
        return this;
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        return this.currentPath.resolveIndexedAccess(selector, isTerminal, creationState);
    }
}

