/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.AssertionFailure;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.Order;
import org.hibernate.query.SortDirection;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.internal.KeyedResult;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class KeyBasedPagination {
    static <R> SqmSelectStatement<KeyedResult<R>> paginate(List<Order<? super R>> keyDefinition, List<Comparable<?>> keyValues, SqmSelectStatement<KeyedResult<R>> statement, NodeBuilder builder) {
        JpaQueryStructure querySpec = statement.getQuerySpec();
        List<SqmSelectableNode<?>> items = ((SqmQuerySpec)querySpec).getSelectClause().getSelectionItems();
        if (items.size() == 1) {
            JpaSelection selected = items.get(0);
            if (selected instanceof SqmRoot) {
                statement.orderBy(keyDefinition.stream().map(order -> SqmUtil.sortSpecification(statement, order)).collect(Collectors.toList()));
                SqmFrom root = (SqmFrom)selected;
                statement.select(KeyBasedPagination.keySelection(keyDefinition, root, selected, builder));
                if (keyValues != null) {
                    SqmPredicate restriction = KeyBasedPagination.keyRestriction(keyDefinition, keyValues, root, builder);
                    SqmPredicate queryWhere = ((SqmQuerySpec)querySpec).getRestriction();
                    statement.where((Expression)(queryWhere == null ? restriction : builder.and((Expression)queryWhere, (Expression)restriction)));
                }
                return statement;
            }
            throw new IllegalQueryOperationException("Select item was not an entity type");
        }
        throw new IllegalQueryOperationException("Query has multiple items in the select list");
    }

    private static <R> SqmPredicate keyRestriction(List<Order<? super R>> keyDefinition, List<Comparable<?>> keyValues, SqmFrom<?, ?> root, NodeBuilder builder) {
        ArrayList<JpaPath> keyPaths = new ArrayList<JpaPath>();
        for (Order<R> key : keyDefinition) {
            keyPaths.add(root.get(key.getAttributeName()));
        }
        SqmPredicate restriction = null;
        for (int i = 0; i < keyDefinition.size(); ++i) {
            SortDirection direction = keyDefinition.get(i).getDirection();
            SqmPath key = (SqmPath)keyPaths.get(i);
            Comparable<?> keyValue = keyValues.get(i);
            List<SqmPath<?>> previousKeys = keyPaths.subList(0, i);
            SqmPredicate predicate = KeyBasedPagination.keyPredicate(key, keyValue, direction, previousKeys, keyValues, builder);
            restriction = restriction == null ? predicate : builder.or((Expression)restriction, (Expression)predicate);
        }
        return restriction;
    }

    private static <R> JpaCompoundSelection<KeyedResult<R>> keySelection(List<Order<? super R>> keyDefinition, SqmFrom<?, ?> root, JpaSelection<?> selected, NodeBuilder builder) {
        ArrayList items = new ArrayList();
        for (Order<R> key : keyDefinition) {
            if (key.getEntityClass() == null) {
                throw new IllegalQueryOperationException("Key-based pagination based on select list items is not yet supported");
            }
            if (!key.getEntityClass().isAssignableFrom(selected.getJavaType())) {
                throw new IllegalQueryOperationException("Select item was of wrong entity type");
            }
            items.add((SqmPath<?>)root.get(key.getAttributeName()));
        }
        return KeyBasedPagination.keyedResultConstructor(selected, builder, items);
    }

    private static <R> JpaCompoundSelection<KeyedResult<R>> keyedResultConstructor(JpaSelection<?> selected, NodeBuilder builder, List<SqmPath<?>> newItems) {
        Class<KeyedResult> resultClass = KeyedResult.class;
        return builder.construct(resultClass, Arrays.asList(selected, builder.construct(List.class, newItems)));
    }

    private static <C extends Comparable<? super C>> SqmPredicate keyPredicate(Expression<? extends C> key, C keyValue, SortDirection direction, List<SqmPath<?>> previousKeys, List<Comparable<?>> keyValues, NodeBuilder builder) {
        JpaPredicate predicate;
        switch (direction) {
            case ASCENDING: {
                predicate = builder.greaterThan((Expression)key, keyValue);
                break;
            }
            case DESCENDING: {
                predicate = builder.lessThan((Expression)key, keyValue);
                break;
            }
            default: {
                throw new AssertionFailure("Unrecognized key direction");
            }
        }
        for (int i = 0; i < previousKeys.size(); ++i) {
            SqmPath<?> keyPath = previousKeys.get(i);
            predicate = builder.and((Expression)predicate, (Expression)keyPath.equalTo(keyValues.get(i)));
        }
        return predicate;
    }
}

