/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.internal;

import org.hibernate.internal.log.SubSystemLogging;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.beans", description="Logging related to Hibernate's support for managed beans (CDI, etc)")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=10005001, max=10010000)
public interface BeansMessageLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.beans";
    public static final BeansMessageLogger BEANS_MSG_LOGGER = Logger.getMessageLogger(BeansMessageLogger.class, "org.hibernate.orm.beans");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10005001, value="An explicit CDI BeanManager reference [%s] was passed to Hibernate, but CDI is not available on the Hibernate ClassLoader.  This is likely going to lead to exceptions later on in bootstrap")
    public void beanManagerButCdiNotAvailable(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10005002, value="No explicit CDI BeanManager reference was passed to Hibernate, but CDI is available on the Hibernate ClassLoader.")
    public void noBeanManagerButCdiAvailable();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10005004, value="Stopping BeanContainer: %s")
    public void stoppingBeanContainer(BeanContainer var1);
}

