/*
 * Decompiled with CFR 0.152.
 */
package repository;

import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyAlreadyExist;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.RepositoryException;
import BlockDynasty.Economy.domain.persistence.entities.ICurrencyRepository;
import jakarta.persistence.NoResultException;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import repository.Mappers.CurrencyMapper;
import repository.Models.CurrencyDb;

public class CurrencyRepository
implements ICurrencyRepository {
    private SessionFactory sessionFactory;

    public CurrencyRepository(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<Currency> findAll() {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                List<Currency> currencies = session.createQuery("SELECT c FROM CurrencyDb c", CurrencyDb.class).getResultList().stream().map(CurrencyMapper::toDomain).collect(Collectors.toList());
                tx.commit();
                List<Currency> list = currencies;
                return list;
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Currency findByUuid(String uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Currency findDefaultCurrency() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Currency findByName(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void save(Currency currency) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                CurrencyDb currencyDb = (CurrencyDb)session.createQuery("SELECT c FROM CurrencyDb c WHERE c.uuid = :uuid OR c.plural = :plural OR c.singular = :singular", CurrencyDb.class).setParameter("uuid", (Object)currency.getUuid().toString()).setParameter("plural", (Object)currency.getPlural()).setParameter("singular", (Object)currency.getSingular()).getSingleResult();
                currencyDb.update(currency);
                session.merge(currencyDb);
                tx.commit();
            }
            catch (NoResultException e) {
                throw new CurrencyNotFoundException("Currency no encontrado: " + String.valueOf(currency.getUuid()));
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void delete(Currency currency) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                CurrencyDb currencyDb = (CurrencyDb)session.createQuery("SELECT c FROM CurrencyDb c WHERE c.uuid = :uuid OR c.plural = :plural OR c.singular = :singular", CurrencyDb.class).setParameter("uuid", (Object)currency.getUuid().toString()).setParameter("plural", (Object)currency.getPlural()).setParameter("singular", (Object)currency.getSingular()).getSingleResult();
                session.remove(currencyDb);
                tx.commit();
            }
            catch (NoResultException e) {
                tx.rollback();
                throw new CurrencyNotFoundException("Currency no encontrado: " + String.valueOf(currency.getUuid()));
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void update(Currency currency) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                CurrencyDb currencyDb = (CurrencyDb)session.createQuery("SELECT c FROM CurrencyDb c WHERE c.uuid = :uuid OR c.plural = :plural OR c.singular = :singular", CurrencyDb.class).setParameter("uuid", (Object)currency.getUuid().toString()).setParameter("plural", (Object)currency.getPlural()).setParameter("singular", (Object)currency.getSingular()).getSingleResult();
                currencyDb.update(currency);
                session.merge(currencyDb);
                tx.commit();
            }
            catch (NoResultException e) {
                throw new CurrencyNotFoundException("Currency no encontrado: " + String.valueOf(currency.getUuid()));
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void create(Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Currency no puede ser nulo");
        }
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                Long count = (Long)session.createQuery("SELECT COUNT(c) FROM CurrencyDb c WHERE c.uuid = :uuid OR c.singular = :singular OR c.plural = :plural", Long.class).setParameter("uuid", (Object)currency.getUuid().toString()).setParameter("singular", (Object)currency.getSingular()).setParameter("plural", (Object)currency.getPlural()).getSingleResult();
                if (count > 0L) {
                    throw new CurrencyAlreadyExist("Ya existe una moneda con el mismo UUID, nombre singular o plural");
                }
                CurrencyDb entity = CurrencyMapper.toEntity(currency);
                session.persist(entity);
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error al crear la moneda: " + e.getMessage(), e);
            }
        }
    }
}

