/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.GUI.adapters;

import BlockDynasty.BukkitImplementation.BlockDynastyEconomy;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.MaterialAdapter;
import com.BlockDynasty.anvilgui.AnvilGUI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TextInput
implements ITextInput {
    @Override
    public void open(IEntityGUI owner, String title, String initialText, Function<String, String> function) {
        Player player = (Player)owner.getRoot();
        new AnvilGUI.Builder().onClick((slot, stateSnapshot) -> {
            player.playSound(player.getLocation(), MaterialAdapter.getClickSound(), 0.3f, 1.0f);
            if (slot != 2) {
                return Collections.emptyList();
            }
            String input = stateSnapshot.getText();
            String response = (String)function.apply(input);
            if (response == null) {
                return List.of(AnvilGUI.ResponseAction.close());
            }
            return List.of(AnvilGUI.ResponseAction.replaceInputText(response));
        }).text(initialText).title(title).plugin((Plugin)BlockDynastyEconomy.getInstance()).open(player);
    }

    @Override
    public void open(IGUI parent, IEntityGUI owner, String title, String initialText, Function<String, String> function) {
        Player player = (Player)owner.getRoot();
        new AnvilGUI.Builder().onClick((slot, stateSnapshot) -> {
            player.playSound(player.getLocation(), MaterialAdapter.getClickSound(), 0.3f, 1.0f);
            if (slot == 2) {
                String input = stateSnapshot.getText();
                String response = (String)function.apply(input);
                if (response == null) {
                    return List.of(AnvilGUI.ResponseAction.close());
                }
                return List.of(AnvilGUI.ResponseAction.replaceInputText(response));
            }
            if (slot == 0) {
                return List.of(AnvilGUI.ResponseAction.close(), AnvilGUI.ResponseAction.run(() -> parent.open()));
            }
            return Collections.emptyList();
        }).text(initialText).title(title).plugin((Plugin)BlockDynastyEconomy.getInstance()).itemLeft(TextInput.createBackItem()).itemOutput(new ItemStack(Material.PAPER)).open(player);
    }

    private static ItemStack createBackItem() {
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta meta = backItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cBack");
            meta.setLore(Arrays.asList("\u00a77Click to go back"));
            backItem.setItemMeta(meta);
        }
        return backItem;
    }
}

