/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.abstractions;

import BlockDynasty.BukkitImplementation.BlockDynastyEconomy;
import BlockDynasty.BukkitImplementation.utils.Version;
import java.util.UUID;
import lib.commands.abstractions.IEntityCommands;
import lib.gui.components.IEntityGUI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.ConsoleCommandSender;

public class EntityConsoleAdapter
implements IEntityCommands {
    private final ConsoleCommandSender commandSender;

    private EntityConsoleAdapter(ConsoleCommandSender commandSender) {
        this.commandSender = commandSender;
    }

    public static EntityConsoleAdapter of(ConsoleCommandSender commandSender) {
        return new EntityConsoleAdapter(commandSender);
    }

    @Override
    public String getName() {
        return "BlockDynasty";
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public UUID getUniqueId() {
        return null;
    }

    @Override
    public void sendMessage(String message) {
        if (!Version.hasSupportAdventureText() || BlockDynastyEconomy.getConfiguration().getBoolean("forceVanillaColorsSystem")) {
            message = this.translateColorCodes(message);
            this.commandSender.sendMessage(message);
        } else {
            Component textonuevo = MiniMessage.miniMessage().deserialize((Object)message);
            this.commandSender.sendMessage(textonuevo);
        }
    }

    private String translateColorCodes(String message) {
        return message.replaceAll("&([0-9a-fk-or])", "");
    }

    @Override
    public void playNotificationSound() {
    }

    @Override
    public boolean hasPermission(String permission) {
        return true;
    }

    @Override
    public void kickPlayer(String message) {
    }

    @Override
    public IEntityGUI asEntityGUI() {
        return null;
    }

    @Override
    public Object getRoot() {
        return this.commandSender;
    }
}

