/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.result;

import BlockDynasty.Economy.domain.result.ErrorCode;

public class Result<T> {
    private final T value;
    private final String errorMessage;
    private final ErrorCode errorCode;

    private Result(T value, String errorMessage, ErrorCode errorCode) {
        this.value = value;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    public static <T> Result<T> success(T value) {
        return new Result<T>(value, null, null);
    }

    public static <T> Result<T> success() {
        return new Result<Object>(null, null, null);
    }

    public static <T> Result<T> failure(String errorMessage, ErrorCode errorCode) {
        return new Result<Object>(null, errorMessage, errorCode);
    }

    public static <T> Result<T> failure(T value, String errorMessage, ErrorCode errorCode) {
        return new Result<T>(value, errorMessage, errorCode);
    }

    public boolean isSuccess() {
        return this.errorMessage == null;
    }

    public boolean isVoid() {
        return this.value == null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public T getValue() {
        return this.value;
    }
}

