/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.abstractions;

import java.util.ArrayList;
import java.util.List;
import lib.commands.abstractions.Command;
import lib.commands.abstractions.IEntityCommands;
import lib.messages.MessageService;

public abstract class AbstractCommand
implements Command {
    private final List<Command> subCommands = new ArrayList<Command>();
    private final List<String> args = new ArrayList<String>();
    private final String name;
    private String description = "";
    private String permission = "";

    public AbstractCommand(String name, String permission, List<String> args) {
        this.name = name;
        this.permission = permission;
        this.args.addAll(args);
    }

    public AbstractCommand(String name, String permission) {
        this.name = name;
        this.permission = permission;
    }

    public void registerSubCommand(Command executor) {
        this.subCommands.add(executor);
    }

    @Override
    public List<Command> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    private boolean hasArgs() {
        return !this.args.isEmpty();
    }

    private boolean hasPermission() {
        return !this.permission.isEmpty();
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (this.hasPermission() && !sender.hasPermission(this.getPermission())) {
            sender.sendMessage(MessageService.getMessage("nopermission"));
            return false;
        }
        if (this.hasArgs() && args.length < this.getArgs().size()) {
            String stringArgs = String.join((CharSequence)" ", this.getArgs());
            sender.sendMessage(">> " + this.getName() + " " + stringArgs);
            return false;
        }
        return true;
    }
}

