/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.accounts;

import BlockDynasty.Economy.aplication.useCase.account.DeleteAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.EditAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.result.Result;
import lib.abstractions.IPlayer;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class EditAccountPanel
extends AbstractPanel {
    private final DeleteAccountUseCase deleteAccountUseCase;
    private final EditAccountUseCase editAccountUseCase;
    private final SearchAccountUseCase searchAccountUseCase;
    private final ITextInput textInput;

    public EditAccountPanel(DeleteAccountUseCase deleteAccountUseCase, EditAccountUseCase editAccountUseCase, SearchAccountUseCase searchAccountUseCase, IEntityGUI sender, Player target, IGUI parent, ITextInput textInput) {
        super("Edit Account: " + target.getNickname(), 5, sender, parent);
        this.deleteAccountUseCase = deleteAccountUseCase;
        this.editAccountUseCase = editAccountUseCase;
        this.searchAccountUseCase = searchAccountUseCase;
        this.textInput = textInput;
        this.buttons(sender, target);
    }

    private void buttons(IEntityGUI sender, Player target) {
        this.setItem(15, this.createItem(Materials.REDSTONE, "Delete account", "The player's account is deleted,before a confirmation"), f -> this.textInput.open(this, sender, "Delete: " + target.getNickname(), "Confirm yes/no", s -> {
            if (s.equals("yes")) {
                Result<Void> result = this.deleteAccountUseCase.execute(target.getNickname());
                if (result.isSuccess()) {
                    sender.sendMessage("The player has been eliminated " + target.getNickname());
                    IPlayer p = platformAdapter.getPlayer(target.getNickname());
                    if (p != null) {
                        p.kickPlayer("Your economy account has been deleted.");
                    }
                    return null;
                }
                sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
                return null;
            }
            this.open();
            return null;
        }));
        this.setItem(40, this.createItem(Materials.BARRIER, "Back", "Click to go back"), f -> GUIFactory.accountSelectorToEdit(sender, this.getParent().getParent()).open());
        this.setItem(29, this.createItem(Materials.PAPER, "Deposit Currency", "Deposit currency into the player's account"), f -> GUIFactory.depositPanel(sender, target, this).open());
        this.setItem(31, this.createItem(Materials.PAPER, "Set balance currency", "Set the balance of a currency in the player's account"), f -> GUIFactory.setPanel(sender, target, this).open());
        this.setItem(33, this.createItem(Materials.PAPER, "Withdraw Currency", "Withdraw currency from the player's account"), f -> GUIFactory.withdrawPanel(sender, target, this).open());
        this.setItem(11, this.createItem(Materials.BOOK, "See Balance", "See the balance of the player's account"), f -> GUIFactory.balancePanel(sender, target.getUuid(), this).open());
        boolean isBlocked = this.searchAccountUseCase.getAccount(target.getUuid()).getValue().isBlocked();
        if (isBlocked) {
            this.setItem(13, this.createItem(Materials.RED_CONCRETE, ChatColor.stringValueOf(Colors.RED) + "Account is blocked", "Click to unblock transactions", "This affects:", "Withdraw", "Deposit", "Transfer", "Pay", "Trade", "Exchange", "All economy op"), f -> {
                Result<Void> result = this.editAccountUseCase.unblockAccount(target.getUuid());
                if (result.isSuccess()) {
                    GUIFactory.editAccountPanel(sender, target, this.getParent()).open();
                } else {
                    sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
                }
            });
        } else {
            this.setItem(13, this.createItem(Materials.LIME_CONCRETE, ChatColor.stringValueOf(Colors.GREEN) + "Account is enabled", "Click to block transactions Account", "This affects:", "Withdraw", "Deposit", "Transfer", "Pay", "Trade", "Exchange", "All economy op"), f -> {
                Result<Void> result = this.editAccountUseCase.blockAccount(target.getUuid());
                if (result.isSuccess()) {
                    GUIFactory.editAccountPanel(sender, target, this.getParent()).open();
                } else {
                    sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
                }
            });
        }
    }
}

