/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users.Offers;

import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.offer.CreateOfferUseCase;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.CurrencySelectorAndAmount;
import lib.gui.templates.users.Offers.CreateOfferFirstPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class CreateOfferSecondPanel
extends CurrencySelectorAndAmount {
    private final Player target;
    private final CreateOfferUseCase createOfferUseCase;
    private final CreateOfferFirstPanel parentGUI;

    public CreateOfferSecondPanel(IEntityGUI player, Player target, SearchCurrencyUseCase searchCurrencyUseCase, CreateOfferUseCase createOfferUseCase, CreateOfferFirstPanel parentGUI, ITextInput textInput) {
        super(player, searchCurrencyUseCase, parentGUI, parentGUI.getCurrency(), textInput);
        this.createOfferUseCase = createOfferUseCase;
        this.target = target;
        this.parentGUI = parentGUI;
    }

    @Override
    protected String execute(IEntityGUI sender, Currency currency, BigDecimal amount) {
        Result<Void> result = this.createOfferUseCase.execute(sender.getUniqueId(), this.target.getUuid(), this.parentGUI.getCurrency().getPlural(), this.parentGUI.getAmount(), currency.getSingular(), amount);
        if (result.isSuccess()) {
            GUIFactory.myActiveOffers(sender).open();
        } else {
            sender.sendMessage(ChatColor.stringValueOf(Colors.RED) + "Error: " + result.getErrorMessage() + "." + String.valueOf((Object)result.getErrorCode()));
        }
        return null;
    }

    @Override
    public void addCustomButtons() {
        this.setItem(4, this.createItem(Materials.PAPER, ChatColor.stringValueOf(Colors.GREEN) + "Select Currency to Receive", ChatColor.stringValueOf(Colors.WHITE) + "Click to select the currency you want to receive", ChatColor.stringValueOf(Colors.WHITE) + "And before that, the amount"), null);
    }
}

