/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.SingleStoreSqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MySQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.EnumJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.OrdinalEnumJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class SingleStoreDialect
extends Dialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 0x100000;
    private static final EmptyExporter NOOP_EXPORTER = new EmptyExporter();
    private static final UniqueDelegate NOOP_UNIQUE_DELEGATE = new DoNothingUniqueDelegate();
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(8, 0);
    private final SingleStoreTableType explicitTableType;
    private final boolean isForUpdateLockingEnabled;
    private final Dialect.SizeStrategy sizeStrategy = new Dialect.SizeStrategyImpl(){

        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            switch (jdbcType.getDdlTypeCode()) {
                case -7: {
                    if (length != null) {
                        return Size.length(Math.min(Math.max(length, 1L), 64L));
                    }
                }
                case 2004: 
                case 2005: 
                case 2011: {
                    return super.resolveSize(jdbcType, javaType, precision, scale, length == null ? SingleStoreDialect.this.getDefaultLobLength() : length.longValue());
                }
            }
            return super.resolveSize(jdbcType, javaType, precision, scale, length);
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState(sqle);
        if (sqlState != null && Integer.parseInt(sqlState) == 23000) {
            return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" for key '", "'", sqle.getMessage());
        }
        return null;
    });
    public static final String SINGLE_STORE_TABLE_TYPE = "hibernate.dialect.singlestore.table_type";
    public static final String SINGLE_STORE_FOR_UPDATE_LOCK_ENABLED = "hibernate.dialect.singlestore.for_update_lock_enabled";

    public SingleStoreDialect() {
        this(MINIMUM_VERSION, null, false);
    }

    public SingleStoreDialect(DialectResolutionInfo info) {
        this(SingleStoreDialect.createVersion(info), SingleStoreDialect.getTableType(info), SingleStoreDialect.getUpdateForEnabled(info));
        this.registerKeywords(info);
    }

    public SingleStoreDialect(DatabaseVersion version, SingleStoreTableType explicitTableType, boolean isForUpdateLockingEnabled) {
        super(version);
        this.explicitTableType = explicitTableType;
        this.isForUpdateLockingEnabled = isForUpdateLockingEnabled;
    }

    private static DatabaseVersion createVersion(DialectResolutionInfo info) {
        String[] components;
        String versionString = info.getDatabaseVersion();
        if (versionString != null && (components = versionString.split("\\.")).length >= 3) {
            try {
                int majorVersion = Integer.parseInt(components[0]);
                int minorVersion = Integer.parseInt(components[1]);
                int patchLevel = Integer.parseInt(components[2]);
                return DatabaseVersion.make(majorVersion, minorVersion, patchLevel);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return info.makeCopyOrDefault(MINIMUM_VERSION);
    }

    private static SingleStoreTableType getTableType(DialectResolutionInfo info) {
        String value = ConfigurationHelper.getString(SINGLE_STORE_TABLE_TYPE, info.getConfigurationValues());
        return value == null ? null : SingleStoreTableType.fromValue(value);
    }

    private static boolean getUpdateForEnabled(DialectResolutionInfo info) {
        return ConfigurationHelper.getBoolean(SINGLE_STORE_FOR_UPDATE_LOCK_ENABLED, info.getConfigurationValues(), false);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+microsecond(?2)/1e6)";
            }
            case WEEK: {
                return "weekofyear(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case EPOCH: {
                return "unix_timestamp(?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (temporalType == TemporalType.TIME) {
            switch (unit) {
                case NANOSECOND: {
                    return "time(timestampadd(microsecond,(?2)/1e3,to_timestamp(?3, 'HH24:MI:SS.FF6')))";
                }
                case NATIVE: {
                    return "time(timestampadd(microsecond, ?2, to_timestamp(?3, 'HH24:MI:SS.FF6')))";
                }
                case SECOND: {
                    return "time(timestampadd(microsecond, ?2 * 1000000, to_timestamp(?3, 'HH24:MI:SS.FF6')))";
                }
            }
            return "time(timestampadd(?1, ?2, to_timestamp(?3, 'HH24:MI:SS.FF6')))";
        }
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd(microsecond,(?2)/1e3,?3)";
            }
            case NATIVE: {
                return "timestampadd(microsecond,?2,?3)";
            }
            case SECOND: {
                return "timestampadd(microsecond,?2 * 1000000,?3)";
            }
        }
        return "timestampadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        String fromType = fromTemporalType == TemporalType.TIME ? "to_timestamp(?2, 'HH24:MI:SS.FF6')" : "?2";
        String toType = toTemporalType == TemporalType.TIME ? "to_timestamp(?3, 'HH24:MI:SS.FF6')" : "?3";
        switch (unit) {
            case NANOSECOND: {
                return String.format("timestampdiff(microsecond,%s,%s)*1e3", fromType, toType);
            }
            case NATIVE: {
                return String.format("timestampdiff(microsecond,%s,%s)", fromType, toType);
            }
        }
        return String.format("timestampdiff(?1,%s,%s)", fromType, toType);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date('");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("')");
                break;
            }
            case TIME: {
                appender.appendSql("time('");
                DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                appender.appendSql("')");
                break;
            }
            case TIMESTAMP: {
                if (temporalAccessor instanceof ZonedDateTime) {
                    temporalAccessor = ((ZonedDateTime)temporalAccessor).toOffsetDateTime();
                }
                appender.appendSql("timestamp('");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone, false);
                appender.appendSql("')");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date('");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("')");
                break;
            }
            case TIME: {
                appender.appendSql("time('");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql("')");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp('");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql("')");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date('");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("')");
                break;
            }
            case TIME: {
                appender.appendSql("time('");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql("')");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp('");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql("')");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return type.append(')').toString();
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        int maxTinyLobLen = 225;
        int maxLobLen = 65535;
        int maxMediumLobLen = 0xFFFFFF;
        CapacityDependentDdlType.Builder varcharBuilder = CapacityDependentDdlType.builder(12, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2005), this.columnType(1), this.castType(1), this).withTypeCapacity(this.getMaxVarcharLength(), "varchar($l)").withTypeCapacity(0xFFFFFFL, "mediumtext");
        if (this.getMaxVarcharLength() < 65535) {
            varcharBuilder.withTypeCapacity(65535L, "text");
        }
        ddlTypeRegistry.addDescriptor(varcharBuilder.build());
        CapacityDependentDdlType.Builder nvarcharBuilder = CapacityDependentDdlType.builder(-9, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2011), this.columnType(-15), this.castType(-15), this).withTypeCapacity(this.getMaxVarcharLength(), "varchar($l) character set utf8").withTypeCapacity(0xFFFFFFL, "mediumtext character set utf8");
        if (this.getMaxVarcharLength() < 65535) {
            nvarcharBuilder.withTypeCapacity(65535L, "text character set utf8");
        }
        ddlTypeRegistry.addDescriptor(nvarcharBuilder.build());
        CapacityDependentDdlType.Builder varbinaryBuilder = CapacityDependentDdlType.builder(-3, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2004), this.columnType(-2), this.castType(-2), this).withTypeCapacity(this.getMaxVarbinaryLength(), "varbinary($l)").withTypeCapacity(0xFFFFFFL, "mediumblob");
        if (this.getMaxVarbinaryLength() < 65535) {
            varbinaryBuilder.withTypeCapacity(65535L, "blob");
        }
        ddlTypeRegistry.addDescriptor(varbinaryBuilder.build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4003, this.columnType(2004), this.castType(-2), this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4001, this.columnType(2005), this.castType(1), this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4002, this.columnType(2005), this.castType(1), this));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2004, this.columnType(2004), this.castType(-2), (Dialect)this).withTypeCapacity(225L, "tinyblob").withTypeCapacity(0xFFFFFFL, "mediumblob").withTypeCapacity(65535L, "blob").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2005, this.columnType(2005), this.castType(1), (Dialect)this).withTypeCapacity(225L, "tinytext").withTypeCapacity(0xFFFFFFL, "mediumtext").withTypeCapacity(65535L, "text").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2011, this.columnType(2011), this.castType(-15), (Dialect)this).withTypeCapacity(225L, "tinytext character set utf8").withTypeCapacity(0xFFFFFFL, "mediumtext character set utf8").withTypeCapacity(65535L, "text character set utf8").build());
        ddlTypeRegistry.addDescriptor(new NativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory commonFunctionFactory = new CommonFunctionFactory(functionContributions);
        commonFunctionFactory.windowFunctions();
        commonFunctionFactory.radians();
        commonFunctionFactory.degrees();
        commonFunctionFactory.cot();
        commonFunctionFactory.log();
        commonFunctionFactory.log2();
        commonFunctionFactory.log10();
        commonFunctionFactory.trim2();
        commonFunctionFactory.octetLength();
        commonFunctionFactory.reverse();
        commonFunctionFactory.pad_space();
        commonFunctionFactory.md5();
        commonFunctionFactory.yearMonthDay();
        commonFunctionFactory.hourMinuteSecond();
        commonFunctionFactory.dayofweekmonthyear();
        commonFunctionFactory.weekQuarter();
        commonFunctionFactory.daynameMonthname();
        commonFunctionFactory.lastDay();
        commonFunctionFactory.date();
        commonFunctionFactory.timestamp();
        commonFunctionFactory.utcDateTimeTimestamp();
        commonFunctionFactory.rand();
        commonFunctionFactory.crc32();
        commonFunctionFactory.sha1();
        commonFunctionFactory.sha2();
        commonFunctionFactory.sha();
        commonFunctionFactory.octetLength();
        commonFunctionFactory.ascii();
        commonFunctionFactory.instr();
        commonFunctionFactory.substr();
        commonFunctionFactory.position();
        commonFunctionFactory.nowCurdateCurtime();
        commonFunctionFactory.trunc_truncate();
        commonFunctionFactory.bitandorxornot_operator();
        commonFunctionFactory.bitAndOr();
        commonFunctionFactory.stddev();
        commonFunctionFactory.stddevPopSamp();
        commonFunctionFactory.variance();
        commonFunctionFactory.varPopSamp();
        commonFunctionFactory.datediff();
        commonFunctionFactory.adddateSubdateAddtimeSubtime();
        commonFunctionFactory.format_dateFormat();
        commonFunctionFactory.makedateMaketime();
        commonFunctionFactory.localtimeLocaltimestamp();
        commonFunctionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        commonFunctionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
        commonFunctionFactory.listagg_groupConcat();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("time").setExactArgumentCount(1).setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).register();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("median", "median(?1) over ()").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.NUMERIC).register();
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.noArgsBuilder("localtime").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP)).setUseParenthesesWhenNoArgs(false).register();
        functionRegistry.patternDescriptorBuilder("pi", "pi() :> double").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(0).setArgumentListSignature("").register();
        functionRegistry.patternDescriptorBuilder("chr", "char(?1 using utf8mb4)").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionRegistry.registerAlternateKey("char", "chr");
    }

    @Override
    public String getCreateTableString() {
        return this.explicitTableType == null ? "create table" : String.format("create %s table", this.explicitTableType.name().toLowerCase());
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        typeContributions.contributeJdbcType(NullJdbcType.INSTANCE);
        typeContributions.contributeType(new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        jdbcTypeRegistry.addDescriptor(EnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(OrdinalEnumJdbcType.INSTANCE);
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case -7: {
                return jdbcTypeRegistry.getDescriptor(-6);
            }
            case 1111: {
                if (!"GEOGRAPHY".equals(columnTypeName) && !"GEOGRAPHYPOINT".equals(columnTypeName)) break;
                jdbcTypeCode = 12;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "bit";
            }
            case 93: {
                return "datetime($p)";
            }
            case 2014: {
                return "timestamp($p)";
            }
            case 2013: {
                return "time($p)";
            }
            case 2: {
                return this.columnType(3);
            }
            case 6: {
                return this.columnType(8);
            }
            case -15: {
                return "char($l) character set utf8";
            }
            case -9: {
                return "varchar($l) character set utf8";
            }
            case 2004: {
                return "longblob";
            }
            case 2011: {
                return "longtext character set utf8";
            }
            case 2005: {
                return "longtext";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (CastType.FLOAT == to || CastType.DOUBLE == to || CastType.OTHER == to) {
            return "?1 :> ?2";
        }
        return super.castPattern(from, to);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -7: 
            case 16: {
                return "unsigned";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "signed";
            }
            case 1: 
            case 12: 
            case 4001: {
                return "char";
            }
            case -15: 
            case -9: 
            case 4002: {
                return "char character set utf8";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "binary";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public String currentTimestamp() {
        return "current_timestamp(6)";
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public long getDefaultLobLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        if (jdbcTypeCode == 1 && precision <= 4) {
            return displaySize;
        }
        return precision;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SingleStoreSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public SchemaNameResolver getSchemaNameResolver() {
        return (connection, dialect) -> "";
    }

    @Override
    public int getInExpressionCountLimit() {
        return 0x100000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return 65533;
    }

    @Override
    public int getMaxVarcharLength() {
        return 21844;
    }

    @Override
    public String getNullColumnString(String columnType) {
        if (columnType.regionMatches(true, 0, "timestamp", 0, "timestamp".length())) {
            return " null";
        }
        return super.getNullColumnString(columnType);
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public boolean supportsTableCheck() {
        return false;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 65;
    }

    @Override
    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\'') {
                appender.appendSql('\'');
            } else if (c == '\\') {
                appender.appendSql('\\');
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SingleStoreDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "%Y").replace("MMMM", "%M").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("ww", "%v").replace("w", "%v").replace("YYYY", "%x").replace("YYY", "%x").replace("YY", "%x").replace("Y", "%x").replace("EEEE", "%W").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("DDD", "%j").replace("DD", "%j").replace("D", "%j").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%l").replace("H", "%k").replace("mm", "%i").replace("m", "%i").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%f").replace("SSSSS", "%f").replace("SSSS", "%f").replace("SSS", "%f").replace("SS", "%f").replace("S", "%f");
    }

    @Override
    public String getDropForeignKeyString() {
        throw new UnsupportedOperationException("SingleStore does not support foreign keys and referential integrity");
    }

    @Override
    public String getDropUniqueKeyString() {
        return "drop index";
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "modify column " + columnName + " " + columnDefinition.trim();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean canCreateCatalog() {
        return true;
    }

    @Override
    public String[] getCreateCatalogCommand(String catalogName) {
        return new String[]{"create database " + catalogName};
    }

    @Override
    public String[] getDropCatalogCommand(String catalogName) {
        return new String[]{"drop database " + catalogName};
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("SingleStore does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("SingleStore does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid()";
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public String getTableComment(String comment) {
        return " comment='" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "create temporary table if not exists";
    }

    @Override
    public String getTemporaryTableDropCommand() {
        return "delete from";
    }

    @Override
    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.DROP;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public int getMaxAliasLength() {
        return 64;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 64;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        throw new UnsupportedOperationException("SingleStore does not support resultsets via stored procedures.");
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsSubqueryOnMutatingTable() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (sqlException.getErrorCode()) {
                case 1205: 
                case 3572: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 1206: 
                case 1207: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 1062: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
            }
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "41000": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    case "40001": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.CATALOG;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        throw new UnsupportedOperationException("SingleStore does not support foreign keys and referential integrity.");
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        throw new UnsupportedOperationException("SingleStore does not support foreign keys and referential integrity.");
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("SingleStore does not support altering primary key.");
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString();
    }

    @Override
    public String getForUpdateString() {
        return this.isForUpdateLockingEnabled ? super.getForUpdateString() : "";
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("key");
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return MySQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean isJdbcLogWarningsEnabledByDefault() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public Exporter<Sequence> getSequenceExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public Exporter<ForeignKey> getForeignKeyExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return NOOP_UNIQUE_DELEGATE;
    }

    public SingleStoreTableType getExplicitTableType() {
        return this.explicitTableType;
    }

    public boolean isForUpdateLockingEnabled() {
        return this.isForUpdateLockingEnabled;
    }

    @Override
    public String getDual() {
        return "dual";
    }

    public static enum SingleStoreTableType {
        COLUMNSTORE,
        ROWSTORE;


        public static SingleStoreTableType fromValue(String value) {
            return Arrays.stream(SingleStoreTableType.values()).filter(v -> v.name().equalsIgnoreCase(value.trim())).findAny().orElseThrow(() -> new IllegalArgumentException("Wrong table type"));
        }
    }

    static class DoNothingUniqueDelegate
    implements UniqueDelegate {
        DoNothingUniqueDelegate() {
        }

        @Override
        public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
            return "";
        }

        @Override
        public String getTableCreationUniqueConstraintsFragment(Table table, SqlStringGenerationContext context) {
            return "";
        }

        @Override
        public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
            return "";
        }

        @Override
        public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
            return "";
        }
    }

    static class EmptyExporter<T extends Exportable>
    implements Exporter<T> {
        EmptyExporter() {
        }

        @Override
        public String[] getSqlCreateStrings(T exportable, Metadata metadata, SqlStringGenerationContext context) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }

        @Override
        public String[] getSqlDropStrings(T exportable, Metadata metadata, SqlStringGenerationContext context) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
    }
}

