/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;

public class FirstSkipLimitHandler
extends AbstractLimitHandler {
    public static final FirstSkipLimitHandler INSTANCE = new FirstSkipLimitHandler();

    @Override
    public String processSql(String sql, Limit limit) {
        boolean hasFirstRow = FirstSkipLimitHandler.hasFirstRow(limit);
        boolean hasMaxRows = FirstSkipLimitHandler.hasMaxRows(limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (hasMaxRows) {
            skipFirst.append(" first ?");
        }
        if (hasFirstRow) {
            skipFirst.append(" skip ?");
        }
        return FirstSkipLimitHandler.insertAfterSelect(skipFirst.toString(), sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public final boolean bindLimitParametersFirst() {
        return true;
    }
}

