/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaJoinedFrom;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.spi.NavigablePath;

public abstract class AbstractSqmQualifiedJoin<O, T>
extends AbstractSqmJoin<O, T>
implements SqmQualifiedJoin<O, T>,
JpaJoinedFrom<O, T> {
    private SqmPredicate onClausePredicate;

    public AbstractSqmQualifiedJoin(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, SqmFrom<?, ?> lhs, String alias, SqmJoinType joinType, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, alias, joinType, nodeBuilder);
    }

    @Override
    protected void copyTo(AbstractSqmQualifiedJoin<O, T> target, SqmCopyContext context) {
        super.copyTo(target, context);
        target.onClausePredicate = this.onClausePredicate == null ? null : this.onClausePredicate.copy(context);
    }

    @Override
    public JpaPredicate getOn() {
        return this.onClausePredicate;
    }

    @Override
    public SqmPredicate getJoinPredicate() {
        return this.onClausePredicate;
    }

    @Override
    public void setJoinPredicate(SqmPredicate predicate) {
        if (log.isTraceEnabled()) {
            log.tracef("Setting join predicate [%s] (was [%s])", (Object)predicate.toString(), (Object)(this.onClausePredicate == null ? "<null>" : this.onClausePredicate.toString()));
        }
        this.onClausePredicate = predicate;
    }

    public void applyRestriction(SqmPredicate restriction) {
        this.onClausePredicate = this.onClausePredicate == null ? restriction : this.nodeBuilder().and((Expression)this.onClausePredicate, (Expression)restriction);
    }

    @Override
    public JpaJoinedFrom<O, T> on(JpaExpression<Boolean> restriction) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap(restriction));
        return this;
    }

    @Override
    public JpaJoinedFrom<O, T> on(Expression<Boolean> restriction) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression)restriction));
        return this;
    }

    @Override
    public JpaJoinedFrom<O, T> on(JpaPredicate ... restrictions) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression[])restrictions));
        return this;
    }

    @Override
    public JpaJoinedFrom<O, T> on(Predicate ... restrictions) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression[])restrictions));
        return this;
    }
}

