/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.hibernate.tool.schema.internal.exec.AbstractScriptSourceInput;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromFile;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.jboss.logging.Logger;

public class ScriptSourceInputFromUrl
extends AbstractScriptSourceInput {
    private static final Logger log = Logger.getLogger(ScriptSourceInputFromFile.class);
    private final URL url;
    private final String charsetName;

    public ScriptSourceInputFromUrl(URL url, String charsetName) {
        this.url = url;
        this.charsetName = charsetName;
    }

    @Override
    public String getScriptDescription() {
        return this.url.toExternalForm();
    }

    @Override
    protected Reader prepareReader() {
        try {
            return this.charsetName != null ? new InputStreamReader(this.url.openStream(), this.charsetName) : new InputStreamReader(this.url.openStream());
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to open specified script source url [" + this.url + "] for reading (" + this.charsetName + ")");
        }
    }

    @Override
    protected void releaseReader(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            log.warn("Unable to close file reader for generation script source");
        }
    }

    @Override
    public boolean containsScript(URL url) {
        return this.url.equals(url);
    }

    public String toString() {
        return "ScriptSourceInputFromUrl(" + this.url.toExternalForm() + ")";
    }
}

