/*
 * Decompiled with CFR 0.152.
 */
package repository;

import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.account.Exceptions.AccountAlreadyExist;
import BlockDynasty.Economy.domain.entities.account.Exceptions.AccountNotFoundException;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.RepositoryException;
import BlockDynasty.Economy.domain.persistence.entities.IAccountRepository;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import repository.Mappers.AccountMapper;
import repository.Models.AccountDb;
import repository.Models.BalanceDb;
import repository.Models.CurrencyDb;
import repository.Models.WalletDb;

public class AccountRepository
implements IAccountRepository {
    @PersistenceContext
    private SessionFactory sessionFactory;

    public AccountRepository(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<Account> findAll() {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                List<Account> accounts = session.createQuery("SELECT DISTINCT a FROM AccountDb a", AccountDb.class).getResultList().stream().map(AccountMapper::toDomain).collect(Collectors.toList());
                tx.commit();
                List<Account> list = accounts;
                return list;
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Account findByUuid(String uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Account findByNickname(String nickname) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void save(Account account) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                AccountDb accountDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a LEFT JOIN FETCH a.wallet w LEFT JOIN FETCH w.balances b LEFT JOIN FETCH b.currency WHERE a.uuid = :uuid OR a.nickname = :name", AccountDb.class).setParameter("uuid", (Object)account.getUuid().toString()).setParameter("name", (Object)account.getNickname()).getSingleResult();
                accountDb.setNickname(account.getNickname());
                accountDb.setUuid(account.getUuid().toString());
                accountDb.setCanReceiveCurrency(account.canReceiveCurrency());
                accountDb.setBlock(account.isBlocked());
                this.updateBalancesInWallet(account, accountDb.getWallet(), session);
                tx.commit();
            }
            catch (NoResultException e) {
                tx.rollback();
                throw new AccountNotFoundException("Account no encontrado: " + String.valueOf(account.getUuid()));
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    private void updateBalancesInWallet(Account account, WalletDb walletDb, Session session) {
        for (Money money : account.getBalances()) {
            String currencyUuid = money.getCurrency().getUuid().toString();
            Optional<BalanceDb> existingBalance = walletDb.getBalances().stream().filter(b -> b.getCurrency().getUuid().equals(currencyUuid)).findFirst();
            if (existingBalance.isPresent()) {
                existingBalance.get().setAmount(money.getAmount());
                continue;
            }
            try {
                CurrencyDb currencyDb = (CurrencyDb)session.createQuery("FROM CurrencyDb WHERE uuid = :uuid", CurrencyDb.class).setParameter("uuid", (Object)currencyUuid).getSingleResult();
                BalanceDb newBalance = new BalanceDb();
                newBalance.setCurrency(currencyDb);
                newBalance.setAmount(money.getAmount());
                newBalance.setWallet(walletDb);
                walletDb.getBalances().add(newBalance);
            }
            catch (NoResultException e) {
                throw new CurrencyNotFoundException("Currency not found: " + currencyUuid);
            }
        }
    }

    @Override
    public void delete(Account account) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                AccountDb accountDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a LEFT JOIN FETCH a.wallet WHERE a.uuid = :uuid OR a.nickname=:name", AccountDb.class).setParameter("uuid", (Object)account.getUuid().toString()).setParameter("name", (Object)account.getNickname()).getSingleResult();
                session.remove(accountDb);
                tx.commit();
            }
            catch (NoResultException e) {
                throw new AccountNotFoundException("Account no encontrado: " + String.valueOf(account.getUuid()));
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void update(Account account) {
        this.save(account);
    }

    @Override
    public void create(Account account) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                Long count = (Long)session.createQuery("SELECT COUNT(a) FROM AccountDb a WHERE a.uuid = :uuid", Long.class).setParameter("uuid", (Object)account.getUuid().toString()).getSingleResult();
                if (count > 0L) {
                    throw new AccountAlreadyExist("Account Ya existe: " + String.valueOf(account.getUuid()));
                }
                AccountDb accountDb = new AccountDb();
                accountDb.setUuid(account.getUuid().toString());
                accountDb.setNickname(account.getNickname());
                accountDb.setCanReceiveCurrency(account.canReceiveCurrency());
                WalletDb walletDb = new WalletDb();
                session.persist(walletDb);
                accountDb.setWallet(walletDb);
                for (Money domainMoney : account.getBalances()) {
                    String currencyUuid = domainMoney.getCurrency().getUuid().toString();
                    CurrencyDb currencyDb = (CurrencyDb)session.createQuery("FROM CurrencyDb WHERE uuid = :uuid", CurrencyDb.class).setParameter("uuid", (Object)currencyUuid).getSingleResult();
                    BalanceDb balanceDb = new BalanceDb();
                    balanceDb.setCurrency(currencyDb);
                    balanceDb.setAmount(domainMoney.getAmount());
                    balanceDb.setWallet(walletDb);
                    walletDb.getBalances().add(balanceDb);
                }
                session.persist(accountDb);
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error repositorio: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public List<Account> getAccountsTopByCurrency(String currencyName, int limit, int offset) {
        try (Session session = this.sessionFactory.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                String hql = "SELECT DISTINCT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE c.singular = :currencyName OR c.plural = :currencyName ORDER BY b.amount DESC";
                List accountDbs = session.createQuery(hql, AccountDb.class).setParameter("currencyName", (Object)currencyName).setFirstResult(offset).setMaxResults(limit).getResultList();
                tx.commit();
                List<Account> list = accountDbs.stream().map(AccountMapper::toDomain).collect(Collectors.toList());
                return list;
            }
            catch (Exception e) {
                tx.rollback();
                throw new RepositoryException("Error retrieving accounts by currency", e);
            }
        }
    }
}

