/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.Integrations.vaultUnloked;

import api.EconomyResponse;
import api.IApi;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.Economy;
import net.milkbowl.vault2.economy.EconomyResponse;
import org.jetbrains.annotations.NotNull;

public class VaultUnlockedHook
implements Economy {
    IApi api;

    public VaultUnlockedHook(IApi api) {
        this.api = api;
    }

    public boolean isEnabled() {
        return false;
    }

    @NotNull
    public String getName() {
        return "BlockDynastyEconomy";
    }

    public boolean hasSharedAccountSupport() {
        return false;
    }

    public boolean hasMultiCurrencySupport() {
        return true;
    }

    @NotNull
    public int fractionalDigits(@NotNull String pluginName) {
        return 0;
    }

    @NotNull
    public String format(@NotNull BigDecimal amount) {
        return this.api.format(amount);
    }

    @NotNull
    public String format(@NotNull String pluginName, @NotNull BigDecimal amount) {
        return this.format(amount);
    }

    @NotNull
    public String format(@NotNull BigDecimal amount, @NotNull String currency) {
        return this.api.format(amount, currency);
    }

    @NotNull
    public String format(@NotNull String pluginName, @NotNull BigDecimal amount, @NotNull String currency) {
        return this.format(amount, currency);
    }

    public boolean hasCurrency(@NotNull String currency) {
        return this.api.existCurrency(currency);
    }

    @NotNull
    public String getDefaultCurrency(@NotNull String pluginName) {
        return this.api.getDefaultCurrencyNameSingular();
    }

    @NotNull
    public String defaultCurrencyNamePlural(@NotNull String pluginName) {
        return this.api.getDefaultCurrencyNamePlural();
    }

    @NotNull
    public String defaultCurrencyNameSingular(@NotNull String pluginName) {
        return this.api.getDefaultCurrencyNameSingular();
    }

    @NotNull
    public Collection<String> currencies() {
        return this.api.getCurrenciesNamesList();
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name) {
        return this.api.createAccount(accountID, name).isSuccess();
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, boolean player) {
        return this.createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName) {
        return this.createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName, boolean player) {
        return this.createAccount(accountID, name);
    }

    @NotNull
    public Map<UUID, String> getUUIDNameMap() {
        return Map.of();
    }

    public Optional<String> getAccountName(@NotNull UUID accountID) {
        String accountResult;
        try {
            accountResult = this.api.getAccount(accountID).getNickname();
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(accountResult);
    }

    public boolean hasAccount(@NotNull UUID accountID) {
        return this.api.existAccount(accountID);
    }

    public boolean hasAccount(@NotNull UUID accountID, @NotNull String worldName) {
        return this.hasAccount(accountID);
    }

    public boolean renameAccount(@NotNull UUID accountID, @NotNull String name) {
        return false;
    }

    public boolean renameAccount(@NotNull String plugin, @NotNull UUID accountID, @NotNull String name) {
        return false;
    }

    public boolean deleteAccount(@NotNull String plugin, @NotNull UUID accountID) {
        return false;
    }

    public boolean accountSupportsCurrency(@NotNull String plugin, @NotNull UUID accountID, @NotNull String currency) {
        return true;
    }

    public boolean accountSupportsCurrency(@NotNull String plugin, @NotNull UUID accountID, @NotNull String currency, @NotNull String world) {
        return true;
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID) {
        return this.api.getBalance(accountID);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world) {
        return this.api.getBalance(accountID);
    }

    @NotNull
    public BigDecimal getBalance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world, @NotNull String currency) {
        return this.api.getBalance(accountID, currency);
    }

    @NotNull
    public BigDecimal balance(@NotNull String pluginName, @NotNull UUID accountID) {
        return this.api.getBalance(accountID);
    }

    @NotNull
    public BigDecimal balance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world) {
        return this.api.getBalance(accountID);
    }

    @NotNull
    public BigDecimal balance(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String world, @NotNull String currency) {
        return this.api.getBalance(accountID, currency);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        return this.api.hasAmount(accountID, amount);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return this.api.hasAmount(accountID, amount);
    }

    public boolean has(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        return this.api.hasAmount(accountID, amount, currency);
    }

    public net.milkbowl.vault2.economy.EconomyResponse set(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        EconomyResponse response = this.api.setBalance(accountID, amount);
        if (response.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.SUCCESS, "set balance success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.FAILURE, "Transaction error" + response.getErrorMessage());
    }

    public net.milkbowl.vault2.economy.EconomyResponse set(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        EconomyResponse response = this.api.setBalance(accountID, amount);
        if (response.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.SUCCESS, "set balance success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.FAILURE, "Transaction error" + response.getErrorMessage());
    }

    public net.milkbowl.vault2.economy.EconomyResponse set(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        EconomyResponse response = this.api.setBalance(accountID, amount, currency);
        if (response.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.SUCCESS, "set balance success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.FAILURE, "Transaction error" + response.getErrorMessage());
    }

    @NotNull
    public net.milkbowl.vault2.economy.EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        EconomyResponse resultWithdraw = this.api.withdraw(accountID, amount);
        if (resultWithdraw.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.SUCCESS, "withdraw success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.FAILURE, "Transaction error" + resultWithdraw.getErrorMessage());
    }

    @NotNull
    public net.milkbowl.vault2.economy.EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return this.withdraw(pluginName, accountID, amount);
    }

    @NotNull
    public net.milkbowl.vault2.economy.EconomyResponse withdraw(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        EconomyResponse resultWithdraw = this.api.withdraw(accountID, amount, currency);
        if (resultWithdraw.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.SUCCESS, "withdraw success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.FAILURE, "Transaction error" + resultWithdraw.getErrorMessage());
    }

    @NotNull
    public net.milkbowl.vault2.economy.EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull BigDecimal amount) {
        EconomyResponse resultDeposit = this.api.deposit(accountID, amount);
        if (resultDeposit.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.SUCCESS, "deposit success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID), EconomyResponse.ResponseType.FAILURE, "Transaction error" + resultDeposit.getErrorMessage());
    }

    @NotNull
    public net.milkbowl.vault2.economy.EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull BigDecimal amount) {
        return this.deposit(pluginName, accountID, amount);
    }

    @NotNull
    public net.milkbowl.vault2.economy.EconomyResponse deposit(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String worldName, @NotNull String currency, @NotNull BigDecimal amount) {
        EconomyResponse resultDeposit = this.api.deposit(accountID, amount, currency);
        if (resultDeposit.isSuccess()) {
            return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID, "", currency), EconomyResponse.ResponseType.SUCCESS, "deposit success for " + String.valueOf(accountID));
        }
        return new net.milkbowl.vault2.economy.EconomyResponse(amount, this.getBalance("", accountID, "", currency), EconomyResponse.ResponseType.FAILURE, "Transaction error" + resultDeposit.getErrorMessage());
    }

    public boolean createSharedAccount(@NotNull String pluginName, @NotNull UUID accountID, @NotNull String name, @NotNull UUID owner) {
        return false;
    }

    public boolean isAccountOwner(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean setOwner(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean isAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean addAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean addAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, AccountPermission ... initialPermissions) {
        return false;
    }

    public boolean removeAccountMember(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid) {
        return false;
    }

    public boolean hasAccountPermission(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, @NotNull AccountPermission permission) {
        return false;
    }

    public boolean updateAccountPermission(@NotNull String pluginName, @NotNull UUID accountID, @NotNull UUID uuid, @NotNull AccountPermission permission, boolean value) {
        return false;
    }
}

