/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.listeners;

import BlockDynasty.BukkitImplementation.adapters.platformAdapter.EntityPlayerAdapter;
import BlockDynasty.BukkitImplementation.scheduler.Scheduler;
import lib.scheduler.ContextualTask;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import platform.listeners.IPlayerJoin;

public class PlayerJoinListenerOnline
implements Listener {
    private IPlayerJoin playerJoin;

    public PlayerJoinListenerOnline(IPlayerJoin playerJoin) {
        this.playerJoin = playerJoin;
    }

    @Deprecated
    @EventHandler(priority=EventPriority.LOWEST)
    public void onLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        Scheduler.run(ContextualTask.build(() -> this.loadPlayerAccount(player)));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Scheduler.run(ContextualTask.build(() -> this.loadPlayerAccount(player)));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.removePlayerCache(event.getPlayer());
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.removePlayerCache(event.getPlayer());
    }

    private void removePlayerCache(Player player) {
        this.playerJoin.offLoadPlayerAccount(EntityPlayerAdapter.of(player));
    }

    protected void loadPlayerAccount(Player player) {
        this.playerJoin.loadOnlinePlayerAccount(EntityPlayerAdapter.of(player));
    }
}

