/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.utils;

import BlockDynasty.BukkitImplementation.scheduler.Scheduler;
import BlockDynasty.BukkitImplementation.utils.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import lib.scheduler.ContextualTask;
import org.bukkit.plugin.java.JavaPlugin;

public class Updater {
    private int project = -1;
    private URL checkURL;
    private String newVersion;
    private String currentVersion;
    private JavaPlugin plugin;

    private Updater(JavaPlugin plugin, int project) {
        this.project = project;
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        try {
            this.checkURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + project);
        }
        catch (MalformedURLException ex) {
            Console.logError("Invalid URL for updater.");
        }
    }

    private String getResourceSpigot() {
        return "https://www.spigotmc.org/resources/" + this.project;
    }

    private String getResourceModrinth() {
        return "https://modrinth.com/plugin/dynastyeconomy";
    }

    private boolean checkForUpdates() {
        if (this.checkURL == null) {
            return false;
        }
        try {
            URLConnection con = this.checkURL.openConnection();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                this.newVersion = reader.readLine();
            }
            return this.newVersion != null && this.isVersionGreater(this.newVersion, this.currentVersion);
        }
        catch (IOException e) {
            Console.log("Can't check update: " + e.getMessage());
            return false;
        }
    }

    private boolean isVersionGreater(String version1, String version2) {
        String[] v1Parts = version1.split("\\.");
        String[] v2Parts = version2.split("\\.");
        int maxLength = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < maxLength; ++i) {
            int v2;
            int v1 = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2 = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1 > v2) {
                return true;
            }
            if (v1 >= v2) continue;
            return false;
        }
        return false;
    }

    private void checkAsync() {
        Scheduler.run(ContextualTask.build(() -> {
            if (this.checkForUpdates()) {
                Console.log("\u00a1New version Available : " + this.newVersion + "!");
                Console.log("Download in Spigot: " + this.getResourceSpigot());
                Console.log("Download in Modrinth: " + this.getResourceModrinth());
            } else {
                Console.log("The plugin is Updated");
            }
        }));
    }

    public static Updater check(JavaPlugin plugin, int project) {
        if (project == -1) {
            return null;
        }
        Updater updater = new Updater(plugin, project);
        updater.checkAsync();
        return updater;
    }
}

