/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.utils;

import BlockDynasty.BukkitImplementation.utils.JavaUtil;
import java.util.Arrays;
import org.bukkit.Bukkit;

public class Version {
    private static final String currentVersion = Bukkit.getBukkitVersion();
    public static final String[] UNSUPPORTED_VERSIONS = new String[]{"1.13", "1.14", "1.15", "1.16"};
    public static final String[] LEGACY_VERSIONS = new String[]{"1.8", "1.9", "1.10", "1.11", "1.12"};
    private static final boolean hasAdventure = JavaUtil.classExists("net.kyori.adventure.text.Component") && JavaUtil.classExists("net.kyori.adventure.text.minimessage.MiniMessage");
    public static final boolean isFolia = JavaUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    public static final boolean isCanvas = JavaUtil.classExists("io.canvasmc.canvas.server.ThreadedServer");
    private static final boolean hasSupportAnvilGUI = !Version.isMohist() && !Version.isHigherThan("1.21.10");

    public static boolean match(String version) {
        return currentVersion.startsWith(version);
    }

    public static boolean match(String ... versions) {
        return Arrays.stream(versions).anyMatch(currentVersion::startsWith);
    }

    public static boolean isMohist() {
        return JavaUtil.classExists("com.mohistmc.MohistMC");
    }

    public static boolean hasSupportAnvilGUI() {
        return hasSupportAnvilGUI;
    }

    public static boolean hasSupportAdventureText() {
        return hasAdventure;
    }

    public static boolean hasFoliaScheduler() {
        return isFolia || isCanvas;
    }

    public static boolean isLegacy() {
        return Version.match(LEGACY_VERSIONS);
    }

    public static boolean isUnsupportedVersion() {
        return Version.match(UNSUPPORTED_VERSIONS);
    }

    public static boolean isHigherThan(String version) {
        String currentClean = currentVersion.split("-")[0];
        String[] currentParts = currentClean.split("\\.");
        String[] compareParts = version.split("\\.");
        int length = Math.max(currentParts.length, compareParts.length);
        for (int i = 0; i < length; ++i) {
            int compareNum;
            int currentNum = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = compareNum = i < compareParts.length ? Integer.parseInt(compareParts[i]) : 0;
            if (currentNum > compareNum) {
                return true;
            }
            if (currentNum >= compareNum) continue;
            return false;
        }
        return false;
    }
}

