/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.events;

import BlockDynasty.Economy.aplication.events.EventRegistry;
import BlockDynasty.Economy.domain.events.Event;
import BlockDynasty.Economy.domain.events.EventHandler;
import BlockDynasty.Economy.domain.events.SerializableEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventManager {
    private final Map<Class<? extends Event>, List<EventHandler<?>>> handlers = new HashMap();

    public <T extends Event> void subscribe(Class<T> eventType, EventHandler<T> handler) {
        this.handlers.computeIfAbsent(eventType, k -> new ArrayList()).add(handler);
    }

    public <T extends Event> void unsubscribe(Class<T> eventType, EventHandler<T> handler) {
        List<EventHandler<?>> eventHandlers = this.handlers.get(eventType);
        if (eventHandlers != null) {
            eventHandlers.remove(handler);
        }
    }

    public <T extends Event> void emit(T event) {
        List<EventHandler<?>> eventHandlers = this.handlers.get(event.getClass());
        if (eventHandlers != null) {
            for (EventHandler<?> handler : new ArrayList(eventHandlers)) {
                handler.handle(event);
                if (!event.isCancelled()) continue;
                break;
            }
        }
    }

    public void processNetworkEvent(String jsonEvent) {
        SerializableEvent event = EventRegistry.deserializeEvent(jsonEvent);
        if (event != null) {
            this.emit(event);
        }
    }
}

