/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase;

import BlockDynasty.Economy.aplication.services.ServicesManager;
import BlockDynasty.Economy.aplication.useCase.account.CreateAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.DeleteAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.EditAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.account.balance.GetBalanceUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.CreateCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.DeleteCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.offer.AcceptOfferUseCase;
import BlockDynasty.Economy.aplication.useCase.offer.CancelOfferUseCase;
import BlockDynasty.Economy.aplication.useCase.offer.CreateOfferUseCase;
import BlockDynasty.Economy.aplication.useCase.offer.SearchOfferUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.DepositUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.ExchangeUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.PayUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.SetBalanceUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.TradeCurrenciesUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.TransferFundsUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.WithdrawUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.IDepositUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.IExchangeUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.ISetBalanceUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.ITradeUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.ITransferUseCase;
import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.IWithdrawUseCase;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.services.courier.Courier;
import BlockDynasty.Economy.domain.services.log.Log;

public class UseCaseFactory {
    private ServicesManager servicesManager;
    private IRepository repository;
    private Courier courier;
    private Log log;

    public UseCaseFactory(ServicesManager servicesManager, IRepository repository, Courier courier, Log log) {
        this.servicesManager = servicesManager;
        this.repository = repository;
        this.courier = courier;
        this.log = log;
    }

    public PayUseCase pay() {
        return new PayUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public CreateAccountUseCase createAccount() {
        return new CreateAccountUseCase(this.servicesManager.getAccountService(), this.servicesManager.getCurrencyService(), this.repository);
    }

    public DeleteAccountUseCase deleteAccount() {
        return new DeleteAccountUseCase(this.repository, this.servicesManager.getAccountService());
    }

    public EditAccountUseCase editAccount() {
        return new EditAccountUseCase(this.servicesManager.getAccountService(), this.repository, this.courier);
    }

    public SearchAccountUseCase searchAccount() {
        return new SearchAccountUseCase(this.servicesManager.getAccountService(), this.repository);
    }

    public DeleteAccountUseCase deleteBalance() {
        return new DeleteAccountUseCase(this.repository, this.servicesManager.getAccountService());
    }

    public GetBalanceUseCase getBalance() {
        return new GetBalanceUseCase(this.searchAccount());
    }

    public CreateCurrencyUseCase createCurrency() {
        return new CreateCurrencyUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.courier, this.repository);
    }

    public DeleteCurrencyUseCase deleteCurrency() {
        return new DeleteCurrencyUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier);
    }

    public EditCurrencyUseCase editCurrency() {
        return new EditCurrencyUseCase(this.servicesManager.getCurrencyService(), this.courier, this.repository);
    }

    public SearchCurrencyUseCase searchCurrency() {
        return new SearchCurrencyUseCase(this.servicesManager.getCurrencyService(), this.repository);
    }

    public IWithdrawUseCase withdraw() {
        return new WithdrawUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public IWithdrawUseCase withdraw(Log log) {
        return new WithdrawUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, log, this.servicesManager.getEventManager());
    }

    public IDepositUseCase deposit() {
        return new DepositUseCase(this.servicesManager.getAccountService(), this.servicesManager.getCurrencyService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public IDepositUseCase deposit(Log log) {
        return new DepositUseCase(this.servicesManager.getAccountService(), this.servicesManager.getCurrencyService(), this.repository, this.courier, log, this.servicesManager.getEventManager());
    }

    public ISetBalanceUseCase setBalance() {
        return new SetBalanceUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public ISetBalanceUseCase setBalance(Log log) {
        return new SetBalanceUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, log, this.servicesManager.getEventManager());
    }

    public IExchangeUseCase exchange() {
        return new ExchangeUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public IExchangeUseCase exchange(Log log) {
        return new ExchangeUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, log, this.servicesManager.getEventManager());
    }

    public ITradeUseCase tradeCurrencies() {
        return new TradeCurrenciesUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public ITradeUseCase tradeCurrencies(Log log) {
        return new TradeCurrenciesUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, log, this.servicesManager.getEventManager());
    }

    public ITransferUseCase transferFunds() {
        return new TransferFundsUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, this.log, this.servicesManager.getEventManager());
    }

    public ITransferUseCase transferFunds(Log log) {
        return new TransferFundsUseCase(this.servicesManager.getCurrencyService(), this.servicesManager.getAccountService(), this.repository, this.courier, log, this.servicesManager.getEventManager());
    }

    public CreateOfferUseCase createOffer() {
        return new CreateOfferUseCase(this.servicesManager.getOfferService(), this.courier, this.servicesManager.getEventManager(), this.searchCurrency(), this.searchAccount());
    }

    public CancelOfferUseCase cancelOffer() {
        return new CancelOfferUseCase(this.servicesManager.getOfferService(), this.courier, this.servicesManager.getEventManager());
    }

    public AcceptOfferUseCase acceptOffer() {
        return new AcceptOfferUseCase(this.servicesManager.getOfferService(), this.courier, this.servicesManager.getEventManager(), this.tradeCurrencies());
    }

    public SearchOfferUseCase searchOffer() {
        return new SearchOfferUseCase(this.servicesManager.getOfferService());
    }
}

