/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.entities.wallet;

import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.wallet.IWallet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Wallet
implements IWallet {
    private List<Money> balances;

    public Wallet() {
        this.balances = new ArrayList<Money>();
    }

    public Wallet(List<Money> monies) {
        this.balances = monies;
    }

    public Wallet(Wallet wallet) {
        this.balances = new ArrayList<Money>();
        for (Money money : wallet.getBalances()) {
            this.balances.add(new Money(money));
        }
    }

    @Override
    public boolean hasCurrency(String currencyName) {
        return this.balances.stream().anyMatch(b -> b.getCurrency().getSingular().equals(currencyName) || b.getCurrency().getPlural().equals(currencyName));
    }

    @Override
    public Money getMoney(Currency currency) {
        return this.balances.stream().filter(b -> b.getCurrency().equals(currency)).findFirst().orElse(null);
    }

    @Override
    public Money getMoney() {
        return this.balances.stream().filter(b -> b.getCurrency().isDefaultCurrency()).findFirst().orElse(null);
    }

    @Override
    public Money getMoney(String currencyName) {
        return this.balances.stream().filter(b -> b.getCurrency().getSingular().equalsIgnoreCase(currencyName) || b.getCurrency().getPlural().equalsIgnoreCase(currencyName)).findFirst().orElse(null);
    }

    @Override
    public void setBalances(List<Money> monies) {
        this.balances = monies;
    }

    @Override
    public void createBalance(Currency currency, BigDecimal amount) {
        Money money = new Money(currency, amount);
        this.balances.add(money);
    }

    @Override
    public List<Money> getBalances() {
        return this.balances;
    }

    public String toString() {
        return "Wallet{balances=" + String.valueOf(this.balances) + "}";
    }
}

