/*
 * Decompiled with CFR 0.152.
 */
package Main;

import BlockDynasty.Economy.Core;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.services.courier.Courier;
import BlockDynasty.Economy.domain.services.log.Log;
import api.Api;
import api.IApi;
import lib.abstractions.PlatformAdapter;
import lib.commands.CommandsFactory;
import lib.gui.GUIFactory;
import lib.gui.components.ITextInput;
import lib.placeholder.PlaceHolder;
import lib.util.colors.ChatColor;
import platform.files.Configuration;
import platform.files.Languages;
import platform.files.logs.EconomyLogger;
import platform.files.logs.VaultLogger;
import platform.listeners.EventListener;
import platform.listeners.IPlayerJoin;
import platform.listeners.PlayerJoinListener;
import platform.proxy.ProxyReceiver;
import platform.proxy.ProxySender;
import redis.Publisher;
import redis.RedisData;
import redis.Subscriber;
import repository.ConnectionHandler.Hibernate.Connection;
import repository.ConnectionHandler.Hibernate.ConnectionHibernateH2;
import repository.ConnectionHandler.Hibernate.ConnectionHibernateMysql;
import repository.ConnectionHandler.Hibernate.ConnectionHibernateSQLite;
import repository.Repository;
import services.Message;
import utils.Console;

public class Economy {
    private Core core;
    private static IRepository repository;
    private PlayerJoinListener playerJoinListener;
    private IApi api;
    private PlaceHolder placeHolder;
    private static Subscriber subscriber;
    private Configuration configuration;
    private Languages languages;
    private PlatformAdapter platformAdapter;

    private Economy(ITextInput textInput, PlatformAdapter platformAdapter) {
        this.platformAdapter = platformAdapter;
        this.configuration = new Configuration(platformAdapter.getDataFolder());
        if (!platformAdapter.hasSupportAdventureText() || this.configuration.getBoolean("forceVanillaColorsSystem")) {
            ChatColor.setupVanilla();
        }
        this.languages = new Languages(platformAdapter.getDataFolder());
        this.languages.loadMessages(this.configuration.getString("lang"));
        Message.addLang(this.languages);
        Console.setConsole(platformAdapter.getConsole(), this.configuration);
        try {
            repository = new Repository(this.getConnection(this.configuration));
        }
        catch (Exception e) {
            Console.logError("Error connection database, check your credentials.");
            throw new RuntimeException(e.getMessage());
        }
        Console.log("Database connected successfully.");
        this.core = new Core(repository, 60, this.createCourierImpl(this.configuration, platformAdapter), new EconomyLogger(this.configuration, platformAdapter.getScheduler()));
        this.createListener(this.configuration, platformAdapter);
        this.api = new Api(this.core);
        this.placeHolder = new PlaceHolder(this.core.getUseCaseFactory());
        this.playerJoinListener = new PlayerJoinListener(this.core.getUseCaseFactory(), this.core.getServicesManager().getAccountService());
        CommandsFactory.init(platformAdapter, this.core.getUseCaseFactory());
        GUIFactory.init(this.core.getUseCaseFactory(), textInput, platformAdapter, new Message());
        EventListener.register(this.core.getServicesManager().getEventManager(), platformAdapter);
    }

    public static Economy init(ITextInput textInput, PlatformAdapter platformAdapter) {
        return new Economy(textInput, platformAdapter);
    }

    private Connection getConnection(Configuration configuration) {
        switch (configuration.getString("sql.type")) {
            case "mysql": {
                return new ConnectionHibernateMysql(configuration.getString("sql.host"), configuration.getInt("sql.port"), configuration.getString("sql.database"), configuration.getString("sql.username"), configuration.getString("sql.password"));
            }
            case "h2": {
                return new ConnectionHibernateH2(configuration.getDatabasePath(), configuration.getBoolean("sql.EnableWebEditorSqlServer"));
            }
            case "sqlite": {
                return new ConnectionHibernateSQLite(configuration.getDatabasePath(), configuration.getBoolean("sql.EnableWebEditorSqlServer"));
            }
        }
        throw new IllegalArgumentException("Unsupported database type: " + configuration.getString("sql.type"));
    }

    private Courier createCourierImpl(Configuration configuration, PlatformAdapter platformAdapter) {
        if (configuration.getBoolean("redis.enabled")) {
            Console.log("Redis Enabled");
            return new Publisher(new RedisData(configuration), platformAdapter);
        }
        Console.log("Redis Disable - Using Proxy System");
        return new ProxySender(platformAdapter);
    }

    private void createListener(Configuration configuration, PlatformAdapter platformAdapter) {
        if (configuration.getBoolean("redis.enabled")) {
            subscriber = new Subscriber(new RedisData(configuration), platformAdapter, this.core.getServicesManager().getOfferService(), this.core.getServicesManager().getCurrencyService(), this.core.getServicesManager().getAccountService(), this.core.getServicesManager().getEventManager());
            subscriber.startListening();
        } else {
            ProxyReceiver.init(this.core.getServicesManager().getAccountService(), this.core.getServicesManager().getCurrencyService(), this.core.getServicesManager().getEventManager(), this.core.getServicesManager().getOfferService(), platformAdapter);
        }
    }

    public static void shutdown() {
        if (repository != null) {
            repository.close();
        }
        if (subscriber != null) {
            subscriber.stopListening();
        }
    }

    public IPlayerJoin getPlayerJoinListener() {
        return this.playerJoinListener;
    }

    public IApi getApi() {
        return this.api;
    }

    public PlaceHolder getPlaceHolder() {
        return this.placeHolder;
    }

    public IApi getApiWithLog(Log log) {
        return new Api(this.core, log);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Log getVaultLogger() {
        return VaultLogger.build(this.configuration, this.platformAdapter.getScheduler());
    }
}

