/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.redis.clients.jedis.csc;

import com.BlockDynasty.redis.clients.jedis.csc.Cache;
import com.BlockDynasty.redis.clients.jedis.csc.CacheConfig;
import com.BlockDynasty.redis.clients.jedis.csc.Cacheable;
import com.BlockDynasty.redis.clients.jedis.csc.DefaultCache;
import com.BlockDynasty.redis.clients.jedis.csc.EvictionPolicy;
import com.BlockDynasty.redis.clients.jedis.csc.LRUEviction;
import com.BlockDynasty.redis.clients.jedis.exceptions.JedisCacheException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class CacheFactory {
    public static Cache getCache(CacheConfig config) {
        if (config.getCacheClass() == null) {
            if (config.getCacheable() == null) {
                throw new JedisCacheException("Cacheable is required to create the default cache!");
            }
            return new DefaultCache(config.getMaxSize(), config.getCacheable(), CacheFactory.getEvictionPolicy(config));
        }
        return CacheFactory.instantiateCustomCache(config);
    }

    private static Cache instantiateCustomCache(CacheConfig config) {
        try {
            Constructor ctorWithCacheable;
            if (config.getCacheable() != null && (ctorWithCacheable = CacheFactory.findConstructorWithCacheable(config.getCacheClass())) != null) {
                return (Cache)ctorWithCacheable.newInstance(config.getMaxSize(), CacheFactory.getEvictionPolicy(config), config.getCacheable());
            }
            Constructor ctor = CacheFactory.getConstructor(config.getCacheClass());
            return (Cache)ctor.newInstance(config.getMaxSize(), CacheFactory.getEvictionPolicy(config));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new JedisCacheException("Failed to insantiate custom cache type!", e);
        }
    }

    private static Constructor findConstructorWithCacheable(Class customCacheType) {
        return Arrays.stream(customCacheType.getConstructors()).filter(ctor -> Arrays.equals(ctor.getParameterTypes(), new Class[]{Integer.TYPE, EvictionPolicy.class, Cacheable.class})).findFirst().orElse(null);
    }

    private static Constructor getConstructor(Class customCacheType) {
        try {
            return customCacheType.getConstructor(Integer.TYPE, EvictionPolicy.class);
        }
        catch (NoSuchMethodException e) {
            String className = customCacheType.getName();
            throw new JedisCacheException(String.format("Failed to find compatible constructor for custom cache type!  Provide one of these;\n - %s(int maxSize, EvictionPolicy evictionPolicy)\n - %s(int maxSize, EvictionPolicy evictionPolicy, Cacheable cacheable)", className, className), e);
        }
    }

    private static EvictionPolicy getEvictionPolicy(CacheConfig config) {
        if (config.getEvictionPolicy() == null) {
            return new LRUEviction(config.getMaxSize());
        }
        return config.getEvictionPolicy();
    }
}

