/*
 * Decompiled with CFR 0.152.
 */
package lib.commands;

import BlockDynasty.Economy.aplication.useCase.UseCaseFactory;
import java.util.ArrayList;
import java.util.List;
import lib.abstractions.PlatformAdapter;
import lib.commands.abstractions.Command;
import lib.commands.templates.administrators.EconomyCommand;
import lib.commands.templates.administrators.EconomyGUICommand;
import lib.commands.templates.administrators.EconomySubcommand.BuyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.CreateCurrencyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.DeleteCurrencyCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditColorCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditDecimalsCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditPayableCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditPluralNameCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditRateCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditSingularNameCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditStartBalCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.EditSymbolCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.ListCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.SetDefaultCommand;
import lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand.ViewCommand;
import lib.commands.templates.administrators.EconomySubcommand.DepositCommand;
import lib.commands.templates.administrators.EconomySubcommand.SetCommand;
import lib.commands.templates.administrators.EconomySubcommand.WithdrawCommand;
import lib.commands.templates.users.BalanceCommand;
import lib.commands.templates.users.BalanceTopCommand;
import lib.commands.templates.users.BankGUICommand;
import lib.commands.templates.users.ExchangeCommand;
import lib.commands.templates.users.OfferCommand;
import lib.commands.templates.users.OfferSubCommand.AcceptOfferCommand;
import lib.commands.templates.users.OfferSubCommand.CancelOfferCommand;
import lib.commands.templates.users.OfferSubCommand.CreateOfferCommand;
import lib.commands.templates.users.OfferSubCommand.DenyOfferCommand;
import lib.commands.templates.users.PayCommand;
import lib.messages.MessageProvider;
import lib.messages.MessageService;

public class CommandsFactory {
    private static PlatformAdapter platformAdapter;
    private static MessageService messageService;
    private static UseCaseFactory useCaseFactory;

    public static void init(PlatformAdapter platformAdapter, UseCaseFactory useCaseFactory) {
        CommandsFactory.platformAdapter = platformAdapter;
        CommandsFactory.useCaseFactory = useCaseFactory;
        Commands.init();
    }

    public static void init(PlatformAdapter platformAdapter, MessageProvider messageProvider, UseCaseFactory useCaseFactory) {
        MessageService.setProvider(messageProvider);
        CommandsFactory.init(platformAdapter, useCaseFactory);
    }

    public static PlatformAdapter getPlatformAdapter() {
        return platformAdapter;
    }

    public static MessageService getMessageProvider() {
        return messageService;
    }

    static {
        messageService = new MessageService();
    }

    public static class Commands {
        private static final List<Command> MainCommands = new ArrayList<Command>();

        public static void init() {
            OfferCommand offerCommand = new OfferCommand();
            EconomyCommand economyCommand = new EconomyCommand();
            CurrencyCommand currencyCommand = new CurrencyCommand();
            WithdrawCommand withdrawCommand = new WithdrawCommand(useCaseFactory.withdraw());
            DepositCommand depositCommand = new DepositCommand(useCaseFactory.deposit());
            SetCommand setCommand = new SetCommand(useCaseFactory.setBalance());
            ExchangeCommand exchangeCommand = new ExchangeCommand(useCaseFactory.exchange());
            BuyCommand buyCommand = new BuyCommand(useCaseFactory.withdraw());
            CreateCurrencyCommand createCurrencyCommand = new CreateCurrencyCommand(useCaseFactory.createCurrency());
            DeleteCurrencyCommand deleteCurrencyCommand = new DeleteCurrencyCommand(useCaseFactory.deleteCurrency());
            EditColorCommand editColorCommand = new EditColorCommand(useCaseFactory.editCurrency());
            EditDecimalsCommand editDecimalsCommand = new EditDecimalsCommand(useCaseFactory.editCurrency());
            EditPayableCommand editPayableCommand = new EditPayableCommand(useCaseFactory.editCurrency());
            EditRateCommand editRateCommand = new EditRateCommand(useCaseFactory.editCurrency());
            EditStartBalCommand editStartBalCommand = new EditStartBalCommand(useCaseFactory.editCurrency());
            ViewCommand ViewCommand2 = new ViewCommand(useCaseFactory.searchCurrency());
            EditSymbolCommand editSymbolCommand = new EditSymbolCommand(useCaseFactory.editCurrency());
            ListCommand listCommand = new ListCommand(useCaseFactory.searchCurrency());
            SetDefaultCommand setDefaultCommand = new SetDefaultCommand(useCaseFactory.editCurrency());
            EditPluralNameCommand editPluralNameCommand = new EditPluralNameCommand(useCaseFactory.editCurrency());
            EditSingularNameCommand editSingularNameCommand = new EditSingularNameCommand(useCaseFactory.editCurrency());
            CreateOfferCommand createOfferCommand = new CreateOfferCommand(useCaseFactory.createOffer());
            CancelOfferCommand cancelOfferCommand = new CancelOfferCommand(useCaseFactory.cancelOffer());
            AcceptOfferCommand acceptOfferCommand = new AcceptOfferCommand(useCaseFactory.acceptOffer());
            DenyOfferCommand denyOfferCommand = new DenyOfferCommand(useCaseFactory.cancelOffer());
            PayCommand payCommand = new PayCommand(useCaseFactory.pay());
            BalanceCommand balanceCommand = new BalanceCommand(useCaseFactory.getBalance());
            BalanceTopCommand balanceTopCommand = new BalanceTopCommand(useCaseFactory.searchAccount());
            BankGUICommand bankGUICommand = new BankGUICommand();
            EconomyGUICommand economyGUICommand = new EconomyGUICommand();
            economyCommand.registerSubCommand(withdrawCommand);
            economyCommand.registerSubCommand(depositCommand);
            economyCommand.registerSubCommand(setCommand);
            economyCommand.registerSubCommand(buyCommand);
            economyCommand.registerSubCommand(currencyCommand);
            economyCommand.registerSubCommand(economyGUICommand);
            currencyCommand.registerSubCommand(createCurrencyCommand);
            currencyCommand.registerSubCommand(deleteCurrencyCommand);
            currencyCommand.registerSubCommand(ViewCommand2);
            currencyCommand.registerSubCommand(editColorCommand);
            currencyCommand.registerSubCommand(editDecimalsCommand);
            currencyCommand.registerSubCommand(editPayableCommand);
            currencyCommand.registerSubCommand(editRateCommand);
            currencyCommand.registerSubCommand(editStartBalCommand);
            currencyCommand.registerSubCommand(editSymbolCommand);
            currencyCommand.registerSubCommand(listCommand);
            currencyCommand.registerSubCommand(setDefaultCommand);
            currencyCommand.registerSubCommand(editPluralNameCommand);
            currencyCommand.registerSubCommand(editSingularNameCommand);
            offerCommand.registerSubCommand(createOfferCommand);
            offerCommand.registerSubCommand(cancelOfferCommand);
            offerCommand.registerSubCommand(acceptOfferCommand);
            offerCommand.registerSubCommand(denyOfferCommand);
            MainCommands.add(economyCommand);
            MainCommands.add(offerCommand);
            MainCommands.add(payCommand);
            MainCommands.add(balanceCommand);
            MainCommands.add(balanceTopCommand);
            MainCommands.add(exchangeCommand);
            MainCommands.add(bankGUICommand);
        }

        public static List<Command> getMainCommands() {
            return MainCommands;
        }

        public static Command getCommand(String commandName) {
            for (Command command : MainCommands) {
                if (!command.getName().equalsIgnoreCase(commandName)) continue;
                return command;
            }
            return null;
        }

        public static void registerMainCommand(Command command) {
            if (Commands.getCommand(command.getName()) == null) {
                MainCommands.add(command);
            }
        }

        public static void registerSubCommand(String mainCommand, Command subCommand) {
            Command command = Commands.getCommand(mainCommand);
            if (command != null) {
                command.registerSubCommand(subCommand);
            }
        }
    }
}

