/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.DeleteCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class DeleteCurrencyCommand
extends AbstractCommand {
    private final DeleteCurrencyUseCase deleteCurrencyUseCase;

    public DeleteCurrencyCommand(DeleteCurrencyUseCase deleteCurrencyUseCase) {
        super("delete", "", List.of("currency"));
        this.deleteCurrencyUseCase = deleteCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String currencyName = args[0];
        try {
            this.deleteCurrencyUseCase.deleteCurrency(currencyName);
            sender.sendMessage("Deleted currency: " + currencyName);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage(e.getMessage() + " ensure you has another currency setted as default.");
        }
        catch (TransactionException e) {
            sender.sendMessage("Error while deleting currency: " + e.getMessage());
        }
        return false;
    }
}

