/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.DecimalNotSupportedException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class EditStartBalCommand
extends AbstractCommand {
    private final EditCurrencyUseCase editCurrencyUseCase;

    public EditStartBalCommand(EditCurrencyUseCase editCurrencyUseCase) {
        super("startBal", "", List.of("currency", "amount"));
        this.editCurrencyUseCase = editCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        double amount;
        if (!super.execute(sender, args)) {
            return false;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage("Invalid amount");
            return false;
        }
        String currencyName = args[0];
        double finalAmount = amount;
        try {
            this.editCurrencyUseCase.editStartBal(currencyName, finalAmount);
            sender.sendMessage("Starting balance for " + currencyName + " set: " + finalAmount);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("unknown currency");
        }
        catch (TransactionException e) {
            sender.sendMessage("Error: " + e.getMessage());
        }
        catch (DecimalNotSupportedException e) {
            sender.sendMessage("No decimal support for " + currencyName);
        }
        return true;
    }
}

