/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand;

import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.IWithdrawUseCase;
import BlockDynasty.Economy.domain.events.Context;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;
import lib.messages.MessageService;

public class WithdrawCommand
extends AbstractCommand {
    private final IWithdrawUseCase withdraw;

    public WithdrawCommand(IWithdrawUseCase withdraw) {
        super("take", "", List.of("player", "amount", "currency"));
        this.withdraw = withdraw;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String target = args[0];
        String montoString = args[1];
        String currencyName = args[2];
        double amount = 0.0;
        try {
            amount = Double.parseDouble(montoString);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageService.getMessage("invalidamount"));
            return false;
        }
        double finalMount = amount;
        Result<Void> result = this.withdraw.execute(target, currencyName, BigDecimal.valueOf(finalMount), Context.COMMAND);
        if (!result.isSuccess()) {
            sender.sendMessage("Withdraw failed: " + String.valueOf((Object)result.getErrorCode()) + " " + result.getErrorMessage());
        } else {
            sender.sendMessage("Withdraw successful");
        }
        return true;
    }
}

