/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.users;

import BlockDynasty.Economy.aplication.useCase.account.balance.GetBalanceUseCase;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.util.List;
import java.util.Map;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;
import lib.messages.MessageService;
import lib.util.colors.ChatColor;

public class BalanceCommand
extends AbstractCommand {
    private final GetBalanceUseCase balance;

    public BalanceCommand(GetBalanceUseCase balance) {
        super("balance", "BlockDynastyEconomy.players.balance");
        this.balance = balance;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        Result<List<Money>> resultBalances = this.balance.getBalances(sender.getName());
        if (!resultBalances.isSuccess()) {
            sender.sendMessage(resultBalances.getErrorMessage() + " " + String.valueOf((Object)resultBalances.getErrorCode()));
        } else {
            for (Money entry : resultBalances.getValue()) {
                Currency currency = entry.getCurrency();
                sender.sendMessage(MessageService.getMessage("Messages.balance.list", Map.of("currencycolor", ChatColor.stringValueOf(currency.getColor()), "format", entry.format())));
            }
        }
        return true;
    }
}

