/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.users.OfferSubCommand;

import BlockDynasty.Economy.aplication.useCase.offer.CreateOfferUseCase;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import java.util.List;
import lib.abstractions.IPlayer;
import lib.commands.CommandsFactory;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class CreateOfferCommand
extends AbstractCommand {
    private final CreateOfferUseCase createOfferUseCase;

    public CreateOfferCommand(CreateOfferUseCase createOfferUseCase) {
        super("create", "", List.of("amount", "currencyAmount", "price", "currencyPrice", "player"));
        this.createOfferUseCase = createOfferUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        double monto;
        double cantidad;
        if (!super.execute(sender, args)) {
            return false;
        }
        try {
            cantidad = Double.parseDouble(args[0]);
            monto = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("Invalid amount");
            return false;
        }
        String tipoCantidad = args[1];
        String tipoMonto = args[3];
        IPlayer target = CommandsFactory.getPlatformAdapter().getPlayer(args[4]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage("");
            return false;
        }
        if (sender.getName().equals(target.getName())) {
            sender.sendMessage("");
            return false;
        }
        Result<Void> result = this.createOfferUseCase.execute(sender.getUniqueId(), target.getUniqueId(), tipoCantidad, BigDecimal.valueOf(cantidad), tipoMonto, BigDecimal.valueOf(monto));
        if (!result.isSuccess()) {
            sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
            return false;
        }
        return true;
    }
}

