/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.components.abstractions;

import BlockDynasty.Economy.domain.entities.account.Player;
import java.util.List;
import java.util.Map;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IItemStack;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.PaginatedPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import lib.util.colors.Message;

public abstract class AccountsList
extends PaginatedPanel<Player> {
    private final ITextInput textInput;

    public AccountsList(String title, int rows, IEntityGUI sender, IGUI parent, ITextInput textInput) {
        super(title, rows, sender, parent, 21);
        this.textInput = textInput;
    }

    public void showPlayers(List<Player> players) {
        this.showItemsPage(players);
    }

    @Override
    protected IItemStack createItemFor(Player player) {
        return this.createItem(Materials.PLAYER_HEAD, player.getNickname(), new String[0]);
    }

    @Override
    protected void functionLeftItemClick(Player player) {
        this.openNextSection(player);
    }

    @Override
    protected void addCustomButtons() {
        this.setItem(39, this.createItem(Materials.NAME_TAG, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "AccountList.button1.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "AccountList.button1.lore")), unused -> this.openAnvilSearch((IEntityGUI)unused));
    }

    protected void openAnvilSearch(IEntityGUI sender) {
        this.textInput.open(this, sender, Message.process("AccountList.button2.nameItem"), Message.process("AccountList.button2.lore"), s -> {
            Player foundPlayer = this.findPlayerByName((String)s);
            if (foundPlayer != null) {
                this.showPlayers(List.of(foundPlayer));
                this.open();
            } else {
                sender.sendMessage(Message.process(Map.of("color", ChatColor.stringValueOf(Colors.RED)), "AccountList.button2.response"));
                this.open();
            }
            return null;
        });
    }

    public abstract Player findPlayerByName(String var1);

    public abstract void openNextSection(Player var1);
}

