/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.components.abstractions;

import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IItemStack;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.PaginatedPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Message;

public abstract class CurrencySelectorAndAmount
extends PaginatedPanel<Currency> {
    private final SearchCurrencyUseCase searchCurrencyUseCase;
    private final IEntityGUI player;
    private final ITextInput textInput;

    public CurrencySelectorAndAmount(IEntityGUI player, SearchCurrencyUseCase searchCurrencyUseCase, IGUI parentGUI, ITextInput textInput) {
        super(Message.process("CurrencySelector.title"), 5, player, parentGUI, 21);
        this.searchCurrencyUseCase = searchCurrencyUseCase;
        this.player = player;
        this.textInput = textInput;
        this.showCurrencies();
    }

    public CurrencySelectorAndAmount(IEntityGUI player, SearchCurrencyUseCase searchCurrencyUseCase, IGUI parentGUI, Currency exceptCurrency, ITextInput textInput) {
        this(player, searchCurrencyUseCase, parentGUI, textInput);
        this.showCurrenciesExcluding(exceptCurrency);
    }

    private void showCurrenciesExcluding(Currency exceptCurrency) {
        List currencies = this.searchCurrencyUseCase.getCurrencies().stream().filter(c -> !c.equals(exceptCurrency)).collect(Collectors.toList());
        this.showItemsPage(currencies);
    }

    private void showCurrencies() {
        List<Currency> currencies = this.searchCurrencyUseCase.getCurrencies();
        this.showItemsPage(currencies);
    }

    @Override
    protected IItemStack createItemFor(Currency currency) {
        String color = ChatColor.stringValueOf(currency.getColor());
        return this.createItem(Materials.GOLD_INGOT, Message.process(Map.of("currency", color + currency.getSingular()), "CurrencySelector.button1.nameItem"), Message.processLines(Map.of("singular", color + currency.getSingular(), "plural", color + currency.getPlural(), "transferable", currency.isTransferable() ? "Yes" : "No", "exchangeRate", color + currency.getExchangeRate()), "CurrencySelector.button1.lore"));
    }

    @Override
    protected void functionLeftItemClick(Currency currency) {
        this.textInput.open(this, this.player, Message.process(Map.of("currency", currency.getSingular()), "CurrencySelector.button2.nameItem"), Message.process("CurrencySelector.button2.lore"), s -> {
            try {
                BigDecimal amount = new BigDecimal((String)s);
                return this.execute(this.player, currency, amount);
            }
            catch (NumberFormatException e) {
                return "Invalid Format";
            }
        });
    }

    protected String execute(IEntityGUI sender, Currency currency, BigDecimal amount) {
        return "execute not implement";
    }
}

