/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.currencies;

import BlockDynasty.Economy.aplication.useCase.currency.DeleteCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.abstractions.CurrencySelectorAndAmount;

public class CurrencyListDelete
extends CurrencySelectorAndAmount {
    private final DeleteCurrencyUseCase deleteCurrencyUseCase;
    private final IEntityGUI player;
    private final ITextInput textInput;

    public CurrencyListDelete(IEntityGUI player, SearchCurrencyUseCase searchCurrencyUseCase, DeleteCurrencyUseCase deleteCurrencyUseCase, IGUI parent, ITextInput textInput) {
        super(player, searchCurrencyUseCase, parent, textInput);
        this.deleteCurrencyUseCase = deleteCurrencyUseCase;
        this.player = player;
        this.textInput = textInput;
    }

    @Override
    public void functionLeftItemClick(Currency currency) {
        this.openAnvilConfirmation(currency);
    }

    public void openAnvilConfirmation(Currency currency) {
        this.textInput.open(this, this.player, "Confirm Deletion", "Type 'delete' to confirm", input -> {
            if ("delete".equalsIgnoreCase((String)input)) {
                return this.execute(currency);
            }
            this.open();
            return "Deletion cancelled.";
        });
    }

    private String execute(Currency currency) {
        try {
            this.deleteCurrencyUseCase.deleteCurrency(currency.getSingular());
            this.openParent();
            return "Currency deleted successfully.";
        }
        catch (CurrencyNotFoundException e) {
            return e.getMessage();
        }
        catch (TransactionException e) {
            return e.getMessage();
        }
    }
}

